/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import com.infomata.data.DataFile;
import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import com.infomata.data.TabFormat;
import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.CorpusReader;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FeatureMatrixReader;
import edu.ucla.fsm.Projection;
import edu.ucla.maxent.BaselineConstraintSearch4;
import edu.ucla.maxent.CompositeRegularizer;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.ConstraintEvaluator;
import edu.ucla.maxent.ConstraintFilter;
import edu.ucla.maxent.CorpusBasedPrepruner4;
import edu.ucla.maxent.DefaultConstraintFilter;
import edu.ucla.maxent.FilterReader;
import edu.ucla.maxent.GrammarReader;
import edu.ucla.maxent.GrammarWriter;
import edu.ucla.maxent.L1Regularizer;
import edu.ucla.maxent.L2Regularizer;
import edu.ucla.maxent.LikelihoodAndEnergyBasedConstraintEvaluator;
import edu.ucla.maxent.ListBasedConstraintSearch;
import edu.ucla.maxent.MaxentModel;
import edu.ucla.maxent.MaxentSubmodel;
import edu.ucla.maxent.MaxentTrainer;
import edu.ucla.maxent.ObservedMinusExpectedConstraintEvaluator;
import edu.ucla.maxent.ObservedOverExpectedConstraintEvaluator;
import edu.ucla.maxent.Regularizer;
import edu.ucla.maxent.TableauWriter;
import edu.ucla.maxent.WeightEliminationRegularizer;
import edu.ucla.util.CommandlineParser;
import edu.ucla.util.SimpleFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import pal.statistics.ChiSquareDistribution;

public class Maxent {
    public static MaxentModel model = null;
    public static Alphabet alphabet = null;
    public static Corpus corpus = null;
    public static Projection[] projection = null;
    public static Corpus sample = null;
    public static Corpus test = null;
    public static String outputPrefix = "";
    public static int maxConSize = 100;
    public static int maxGramSizeDefault = 3;
    public static int numberOfConstraints = 0;
    public static int WORD_BOUNDARY_SYMBOL = 0;
    public static double l1 = 0.0;
    public static double l2 = 0.0;
    public static double sigma2 = 1.0;
    public static double scale = 1.0;
    public static double alpha = 0.01;
    public static int beta = 0;
    public static double gamma = 0.0;
    public static double dataPlog = 0.0;
    public static double objectiveValue = 0.0;
    public static int minWordLength = 1;
    public static int maxWordLength = 1;
    public static int minimumSampleSize = 50000;
    public static int maximumSampleSize = 50000;
    public static int maxFeaturesPerClass = -1;
    public static int maxSegmentsPerClass = -1;
    public static double epsilon = 1.0E-50;
    public static boolean complementClassesFlag = false;
    public static boolean identityConstraintsFlag = false;
    public static boolean buildEvalFlag = true;
    public static boolean cyclicEvalFlag = false;
    public static boolean addStarSegment = true;
    public static int saveEveryN = 0;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        Object[] objectArray;
        DataRow dataRow;
        Object object2;
        Object object3;
        Object object4;
        CommandlineParser commandlineParser = new CommandlineParser();
        commandlineParser.addOption("features", true, "file containing feature matrix");
        commandlineParser.addOption("complementClasses", false, "use complement natural classes");
        commandlineParser.addOption("maxFeaturesPerClass", true, "maximum number of features per natural class (default is unbounded); inconsistent with -prePrune");
        commandlineParser.addOption("maxSegmentsPerClass", true, "maximum number of segments per natural class (default is unbounded); inconsistent with -prePrune");
        commandlineParser.addOption("identityConstraints", false, "allow constraints with backreferences");
        commandlineParser.addOption("corpus", true, "file containing learning data");
        commandlineParser.addOption("projections", true, "file containing projection list");
        commandlineParser.addOption("test", true, "file containing testing list");
        commandlineParser.addOption("minWordLength", true, "minimum length of words in eval and samples");
        commandlineParser.addOption("maxWordLength", true, "maximum length of words in eval and samples");
        commandlineParser.addOption("maxConSize", true, "maximum number of constraints to select");
        commandlineParser.addOption("maxGramSize", true, "maximum length of subsequences and selected constraints (overridden by projection-specific settings)");
        commandlineParser.addOption("l1", true, "coefficient of the l1 (Laplace, double-exponential) regularizer");
        commandlineParser.addOption("l2", true, "multiplier of the l2 (Gaussian) regularizer");
        commandlineParser.addOption("sigma2", true, "variance of the l2 (Gaussian) regularizer");
        commandlineParser.addOption("scale", true, "data multiplier (the frequency of every corpus item is multiplied by _scale_; default value is 1.0)");
        commandlineParser.addOption("alpha", true, "alpha level of the likelihood ratio test that is used to halt constraint selection");
        commandlineParser.addOption("beta", true, "additive smoothing parameter (the frequencies of all *types* are increased by adding beta (default value is 0)");
        commandlineParser.addOption("gamma", true, "scales 'energy' (neg. harmony) term relative to neg. log. prob. term in the objective function (default value is 0.0)");
        commandlineParser.addOption("filter", true, "file containing a (hard) filter on Sigma*");
        commandlineParser.addOption("inviolable", true, "file containing hard constraints");
        commandlineParser.addOption("grammar", true, "file containing soft constraints and weights");
        commandlineParser.addOption("output", true, "prefix of the grammar/tableau files written after learning/training");
        commandlineParser.addOption("select", false, "learn constraints");
        commandlineParser.addOption("selectFromList", true, "learn constraints from a pre-given list");
        commandlineParser.addOption("evaluator", true, "method for selecting constraints (default is gain-based method; alternatives are `observedOverExpected' and `grafting')");
        commandlineParser.addOption("train", false, "train weights");
        commandlineParser.addOption("prune", false, "recompute negLogProb of corpus with each constraint removed");
        commandlineParser.addOption("weightElim", true, "use weight elimination regularizer; parameter is (sigma_2)^2");
        commandlineParser.addOption("cyclicEval", false, "eval (if built) is a cyclic machine that accepts Sigma*");
        commandlineParser.addOption("doNotAddStarSeg", false, "if set, the *segment constraint is not added to the grammar");
        commandlineParser.addOption("doNotBuildEval", false, "do not build eval (useful only for testing, not selection or training)");
        commandlineParser.addOption("prePrune", false, "prune the constraint search space before selection begins");
        commandlineParser.addOption("saveEveryN", true, "save the grammar after every N constraints (N an integer)");
        commandlineParser.addOption("sample", false, "print a sample from the grammar (either read from a file or after learning)");
        commandlineParser.addOption("printGrammar", false, "print the grammar (with observed and expected values for every constraint)");
        Object[] objectArray2 = SimpleFileReader.apply((String)stringArray[0]);
        System.out.println("args=" + Arrays.toString(objectArray2));
        commandlineParser.parse((String[])objectArray2);
        if (commandlineParser.hasOption("output")) {
            outputPrefix = commandlineParser.getOptionValue("output");
        }
        if (commandlineParser.hasOption("maxFeaturesPerClass")) {
            if (commandlineParser.hasOption("prePrune")) {
                System.out.println("-maxFeaturesPerClass is incompatible with -prePrune");
                System.exit(1);
            }
            maxFeaturesPerClass = Integer.parseInt(commandlineParser.getOptionValue("maxFeaturesPerClass"));
        }
        if (commandlineParser.hasOption("maxSegmentsPerClass")) {
            if (commandlineParser.hasOption("prePrune")) {
                System.out.println("-maxSegmentsPerClass is incompatible with -prePrune");
                System.exit(1);
            }
            maxSegmentsPerClass = Integer.parseInt(commandlineParser.getOptionValue("maxSegmentsPerClass"));
        }
        if (commandlineParser.hasOption("minWordLength")) {
            minWordLength = Integer.parseInt(commandlineParser.getOptionValue("minWordLength"));
        }
        if (commandlineParser.hasOption("maxWordLength")) {
            maxWordLength = Integer.parseInt(commandlineParser.getOptionValue("maxWordLength"));
        }
        if (commandlineParser.hasOption("maxConSize")) {
            maxConSize = Integer.parseInt(commandlineParser.getOptionValue("maxConSize"));
        }
        if (commandlineParser.hasOption("maxGramSize")) {
            maxGramSizeDefault = Integer.parseInt(commandlineParser.getOptionValue("maxGramSize"));
        }
        if (commandlineParser.hasOption("sigma2")) {
            sigma2 = Double.parseDouble(commandlineParser.getOptionValue("sigma2"));
        }
        if (commandlineParser.hasOption("scale")) {
            scale = Double.parseDouble(commandlineParser.getOptionValue("scale"));
        }
        if (commandlineParser.hasOption("gamma") && (gamma = Double.parseDouble(commandlineParser.getOptionValue("gamma"))) < 0.0) {
            System.out.println("Error: gamma (the coefficient of the energy term) must be >= 0.0 (default is 0.0)");
            System.exit(1);
        }
        if (commandlineParser.hasOption("alpha") && ((alpha = Double.parseDouble(commandlineParser.getOptionValue("alpha"))) <= 0.0 || alpha >= 1.0)) {
            System.out.println("Error: alpha (the alpha value of the log-likelihood ratio test) must be in (0,1) (default is 0.01)");
            System.exit(1);
        }
        if (commandlineParser.hasOption("beta") && (beta = Integer.parseInt(commandlineParser.getOptionValue("beta"))) < 0) {
            System.out.println("Error: beta (the additive smoothing parameter for type frequencies) must be an integer >= 0 (default is 0)");
            System.exit(1);
        }
        if (commandlineParser.hasOption("saveEveryN")) {
            saveEveryN = Integer.parseInt(commandlineParser.getOptionValue("saveEveryN"));
        }
        if (commandlineParser.hasOption("complementClasses")) {
            complementClassesFlag = true;
        }
        if (commandlineParser.hasOption("identityConstraints")) {
            identityConstraintsFlag = true;
        }
        if (commandlineParser.hasOption("cyclicEval")) {
            cyclicEvalFlag = true;
        }
        if (commandlineParser.hasOption("doNotAddStarSeg")) {
            addStarSegment = false;
        }
        if (commandlineParser.hasOption("doNotBuildEval")) {
            buildEvalFlag = false;
        }
        alphabet = FeatureMatrixReader.apply((String)commandlineParser.getOptionValue("features"), (boolean)complementClassesFlag, (int)-1);
        if (commandlineParser.hasOption("corpus")) {
            System.out.println("Reading corpus ...");
            corpus = CorpusReader.apply((String)commandlineParser.getOptionValue("corpus"), (Alphabet)alphabet, (int)beta, (boolean)true);
            corpus.compile();
            maxWordLength = Maxent.corpus.empiricalLengthDistrib.length - 1;
        }
        if (!commandlineParser.hasOption("projections")) {
            projection = new Projection[1];
            Maxent.projection[0] = new Projection(alphabet);
            Maxent.projection[0].maxGramSize = maxGramSizeDefault;
            projection[0].setCorpus(corpus);
        } else {
            object4 = new LinkedList<Projection>();
            object3 = null;
            object3 = new Projection(alphabet);
            ((Projection)object3).maxGramSize = maxGramSizeDefault;
            object3.setCorpus(corpus);
            ((LinkedList)object4).add(object3);
            object2 = DataFile.createReader((String)"8859_1");
            object2.setDataFormat((DataFormat)new TabFormat());
            object2.open(new File(commandlineParser.getOptionValue("projections")));
            dataRow = object2.next();
            while (dataRow != null) {
                objectArray = new String[dataRow.size()];
                for (n = 0; n < dataRow.size(); ++n) {
                    objectArray[n] = dataRow.getString(n);
                }
                object3 = new Projection(alphabet, objectArray, complementClassesFlag, maxFeaturesPerClass);
                ((Projection)object3).maxGramSize = objectArray.length > 3 ? Integer.parseInt(objectArray[3]) : maxGramSizeDefault;
                object3.setCorpus(corpus);
                ((LinkedList)object4).add(object3);
                dataRow = object2.next();
            }
            projection = ((LinkedList)object4).toArray(new Projection[0]);
        }
        if (commandlineParser.hasOption("test")) {
            test = CorpusReader.apply((String)commandlineParser.getOptionValue("test"), (Alphabet)alphabet, (int)0, (boolean)true);
        }
        object4 = null;
        if (commandlineParser.hasOption("weightElim")) {
            object4 = new WeightEliminationRegularizer(sigma2, Double.parseDouble(commandlineParser.getOptionValue("weightElim")));
        } else {
            object3 = new ArrayList();
            object2 = new ArrayList();
            if (commandlineParser.hasOption("l1")) {
                l1 = Double.parseDouble(commandlineParser.getOptionValue("l1"));
                ((ArrayList)object3).add(new L1Regularizer());
                ((ArrayList)object2).add(l1);
            }
            if (commandlineParser.hasOption("sigma2")) {
                sigma2 = Double.parseDouble(commandlineParser.getOptionValue("sigma2"));
            }
            if (commandlineParser.hasOption("l2") || commandlineParser.hasOption("sigma2")) {
                l2 = commandlineParser.hasOption("l2") ? Double.parseDouble(commandlineParser.getOptionValue("l2")) : 1.0;
                ((ArrayList)object3).add(new L2Regularizer(0.0, sigma2));
                ((ArrayList)object2).add(l2);
            }
            if (((ArrayList)object3).size() != 0) {
                dataRow = ((ArrayList)object3).toArray(new Regularizer[0]);
                objectArray = new double[((ArrayList)object2).size()];
                for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                    objectArray[n] = (String)((Object)((Double)((ArrayList)object2).get(n)));
                }
                object4 = new CompositeRegularizer((Regularizer[])dataRow, (double[])objectArray);
                ((ArrayList)object3).clear();
                object3 = null;
                ((ArrayList)object2).clear();
                object2 = null;
            }
        }
        model = new MaxentModel(alphabet, corpus, (Regularizer)object4, null, null, buildEvalFlag, cyclicEvalFlag, addStarSegment);
        if (commandlineParser.hasOption("filter")) {
            System.out.println("Reading filter ...");
            object3 = FilterReader.apply(commandlineParser.getOptionValue("filter"), alphabet);
            model.addFilter((FSM)object3);
        }
        if (commandlineParser.hasOption("inviolable")) {
            GrammarReader.apply(commandlineParser.getOptionValue("inviolable"));
            for (int i = 0; i < GrammarReader.constraints.size(); ++i) {
                model.addHardConstraint(GrammarReader.constraints.get(i));
            }
        }
        if (commandlineParser.hasOption("grammar")) {
            GrammarReader.apply(commandlineParser.getOptionValue("grammar"));
            Constraint[] constraintArray = GrammarReader.constraints.toArray(new Constraint[0]);
            object2 = null;
            if (GrammarReader.hasWeights) {
                object2 = new double[GrammarReader.weights.size()];
                for (int i = 0; i < GrammarReader.weights.size(); ++i) {
                    object2[i] = GrammarReader.weights.get(i);
                }
            }
            model.addSoftConstraint(constraintArray, (double[])object2);
        }
        ConstraintEvaluator constraintEvaluator = null;
        if (commandlineParser.hasOption("evaluator")) {
            object2 = commandlineParser.getOptionValue("evaluator");
            if (((String)object2).equals("observedOverExpected")) {
                constraintEvaluator = new ObservedOverExpectedConstraintEvaluator();
            } else if (((String)object2).equals("grafting")) {
                constraintEvaluator = new ObservedMinusExpectedConstraintEvaluator();
            } else if (!((String)object2).equals("gain")) {
                System.out.println("Unknown value of parameter -evaluator");
                System.exit(1);
            }
        }
        if (constraintEvaluator == null) {
            constraintEvaluator = new LikelihoodAndEnergyBasedConstraintEvaluator(alpha);
        }
        object2 = new DefaultConstraintFilter(maxFeaturesPerClass, maxSegmentsPerClass);
        if (commandlineParser.hasOption("prePrune")) {
            for (Projection projection : Maxent.projection) {
                CorpusBasedPrepruner4 corpusBasedPrepruner4 = new CorpusBasedPrepruner4(projection, (ConstraintFilter)object2);
                projection.searchSpace = corpusBasedPrepruner4.S;
            }
        }
        if (commandlineParser.hasOption("select")) {
            int n2;
            System.out.println("Learning constraints ...");
            MaxentTrainer maxentTrainer = new MaxentTrainer();
            int n3 = projection.length;
            BaselineConstraintSearch4[] baselineConstraintSearch4Array = new BaselineConstraintSearch4[projection.length];
            for (n2 = 0; n2 < projection.length; ++n2) {
                baselineConstraintSearch4Array[n2] = new BaselineConstraintSearch4(projection[n2], constraintEvaluator, (ConstraintFilter)object2);
            }
            n2 = 1;
            while (numberOfConstraints < maxConSize && n2 != 0) {
                n2 = 0;
                for (int i = n3 - 1; i >= 0; --i) {
                    System.out.println("Searching constraints on projection " + Maxent.projection[i].name + " ...");
                    System.out.println("Making sample ...");
                    sample = model.getSample();
                    sample.compile();
                    projection[i].setSample(sample);
                    if (baselineConstraintSearch4Array[i] == null || (object = (Object)baselineConstraintSearch4Array[i].apply()) == null) continue;
                    n2 = 1;
                    model.addSoftConstraint((Constraint)object, true);
                    System.out.println(model);
                    int n4 = model.getNumConstraints();
                    System.out.println("number of constraints: " + n4 + "\n");
                    if (n4 % 50 == 0) {
                        projection[0].printSample();
                    }
                    if (saveEveryN == 0 || n4 % saveEveryN != 0) continue;
                    String string = outputPrefix + "grammar" + n4 + ".txt";
                    GrammarWriter.apply(string, alphabet, model);
                }
            }
        }
        if (commandlineParser.hasOption("selectFromList")) {
            MaxentTrainer maxentTrainer = new MaxentTrainer();
            GrammarReader.apply(commandlineParser.getOptionValue("selectFromList"));
            ListBasedConstraintSearch listBasedConstraintSearch = new ListBasedConstraintSearch(projection[0], constraintEvaluator, GrammarReader.constraints);
            boolean bl = true;
            while (bl) {
                System.out.println("Making sample ...");
                sample = model.getSample();
                sample.compile();
                projection[0].setSample(sample);
                Constraint constraint = listBasedConstraintSearch.apply();
                if (constraint != null) {
                    bl = true;
                    model.addSoftConstraint(constraint, true);
                    System.out.println(model);
                    continue;
                }
                bl = false;
            }
        }
        if (commandlineParser.hasOption("train")) {
            System.out.println("training ...");
            MaxentTrainer maxentTrainer = new MaxentTrainer();
            if (Maxent.model.lambda != null) {
                maxentTrainer.apply(model, Maxent.model.lambda);
            } else {
                maxentTrainer.apply(model);
            }
            System.out.println(model);
            String string = null;
            string = outputPrefix.equals("") ? "grammar.txt" : outputPrefix + "_" + "grammar.txt";
            GrammarWriter.apply(string, alphabet, model);
            System.out.println("\ndata plog after training = " + model.getDataPlog());
        }
        if (commandlineParser.hasOption("sample")) {
            sample = model.getSample();
            sample.compile();
            projection[0].setSample(sample);
            projection[0].printSample();
            System.out.println();
        }
        if (commandlineParser.hasOption("test")) {
            System.out.println("testing ...");
            String string = null;
            string = outputPrefix.equals("") ? "tableau.txt" : outputPrefix + "_" + "tableau.txt";
            TableauWriter.apply(string, alphabet, model, test);
        }
        if (commandlineParser.hasOption("prune")) {
            int n5;
            System.out.println("getting data plog with each constraint left out ...\n");
            MaxentSubmodel maxentSubmodel = null;
            MaxentTrainer maxentTrainer = new MaxentTrainer();
            int n6 = Maxent.model.constraintList.size();
            boolean[] blArray = new boolean[n6];
            double[] dArray = new double[n6];
            object = new double[n6];
            double[] dArray2 = new double[n6];
            maxentTrainer.apply(model);
            System.out.println(model);
            double d = model.getDataPlog();
            double[] dArray3 = Arrays.copyOf(Maxent.model.lambda, Maxent.model.lambda.length);
            for (n5 = 0; n5 < n6; ++n5) {
                System.out.print("\tremoving constraint " + n5 + " ... ");
                Arrays.fill(blArray, true);
                blArray[n5] = false;
                maxentSubmodel = new MaxentSubmodel(model, blArray);
                maxentTrainer.apply(maxentSubmodel);
                dArray[n5] = maxentSubmodel.getDataPlog();
                System.out.println("\n" + dArray[n5]);
            }
            for (n5 = 0; n5 < n6; ++n5) {
                object[n5] = 2.0 * (dArray[n5] - d);
                dArray2[n5] = object[n5] <= 0.0 ? 1.0 : 1.0 - ChiSquareDistribution.cdf((double)object[n5], (double)1.0);
            }
            System.out.println("subset\tplog\tchi^2\tp-value");
            System.out.println("all\t" + d + "\tNA\tNA\tNA");
            Constraint constraint = null;
            double d2 = 0.05;
            for (int i = 0; i < n6; ++i) {
                constraint = Maxent.model.constraintList.get(i);
                System.out.println("- " + constraint + "\t" + dArray[i] + "\t" + object[i] + "\t" + dArray2[i] + "\t" + (dArray2[i] < d2 ? "*" : "n.s."));
            }
        }
        if (commandlineParser.hasOption("printGrammar")) {
            model.getExpected();
            System.out.println(model);
        }
    }
}

