/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Projection;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.ConstraintEvaluator;
import edu.ucla.maxent.Maxent;
import java.util.LinkedList;

public class ListBasedConstraintSearch {
    Projection projection = null;
    ConstraintEvaluator evaluator = null;
    LinkedList<Constraint> L = new LinkedList();
    Constraint bestConstraint = null;
    double bestValue = 0.0;

    ListBasedConstraintSearch(Projection projection, ConstraintEvaluator constraintEvaluator, LinkedList<Constraint> linkedList) {
        this.projection = projection;
        this.evaluator = constraintEvaluator;
        this.L.clear();
        this.L.addAll(linkedList);
        System.out.println(this.L);
    }

    public Constraint apply() {
        if (this.L.isEmpty()) {
            return null;
        }
        System.out.println("Searching for a new constraint ...");
        System.out.println("constraint\tobserved\texpected\tgain");
        this.bestConstraint = null;
        this.bestValue = this.evaluator.floor();
        double d = 0.0;
        for (Constraint constraint : this.L) {
            constraint.projection = this.projection;
            double d2 = (double)constraint.evaluateCorpus() * Maxent.scale;
            double d3 = (double)constraint.evaluateSample() / (double)Maxent.sample.size * (double)Maxent.corpus.size * Maxent.scale;
            d = this.evaluator.apply(constraint);
            if (this.evaluator.compare(d, this.bestValue) == -1.0) {
                this.bestConstraint = constraint;
                this.bestValue = d;
            }
            System.out.println(constraint + "\t" + d2 + "\t" + d3 + "\t" + d);
        }
        this.L.remove(this.bestConstraint);
        return this.bestConstraint;
    }
}

