/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.Projection;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.ConstraintEvaluator;
import edu.ucla.maxent.Maxent;
import edu.ucla.util.Counter;
import java.util.Arrays;
import java.util.Map;
import pal.statistics.ChiSquareDistribution;

public class LikelihoodAndEnergyBasedConstraintEvaluator
extends ConstraintEvaluator {
    Projection projection = null;
    Corpus data = null;
    Corpus sample = null;
    double ALPHA = 0.01;
    double CHISQ_CRITICAL = ChiSquareDistribution.quantile((double)(1.0 - this.ALPHA), (double)1.0);
    double FLOOR = 0.0;
    private int MAXIMUM_VIOLATIONS = 50;
    private double[] g_master = new double[this.MAXIMUM_VIOLATIONS];
    private double[] g = null;
    private double dataSize = 0.0;
    private double sampleSize = 0.0;
    private double observedPerForm = 0.0;
    int verbosity = 0;

    public LikelihoodAndEnergyBasedConstraintEvaluator() {
    }

    public LikelihoodAndEnergyBasedConstraintEvaluator(double d) {
        this.ALPHA = d;
        this.CHISQ_CRITICAL = ChiSquareDistribution.quantile((double)(1.0 - this.ALPHA), (double)1.0);
        System.out.println("LikelihoodBasedConstraintEvalutor2: critical chi-square value = " + this.CHISQ_CRITICAL);
    }

    @Override
    public void setData(Corpus corpus) {
        this.data = corpus;
    }

    @Override
    public void setSample(Corpus corpus) {
        this.sample = corpus;
    }

    public void setAlpha(double d) {
        this.ALPHA = d;
        this.CHISQ_CRITICAL = ChiSquareDistribution.quantile((double)(1.0 - this.ALPHA), (double)1.0);
    }

    public void setObservedPerForm(double d) {
        this.observedPerForm = d;
    }

    public void setG(double[] dArray) {
        this.g = dArray;
    }

    @Override
    public double floor() {
        return this.FLOOR;
    }

    @Override
    public double apply(Constraint constraint) {
        return this.apply(constraint, null, -1.0);
    }

    public double apply(Constraint constraint, double[] dArray) {
        return this.apply(constraint, dArray, -1.0);
    }

    @Override
    public double apply(Constraint constraint, double d, double d2) {
        return this.apply(constraint, null, d);
    }

    public double apply(Constraint constraint, double[] dArray, double d) {
        this.dataSize = Maxent.corpus.size;
        if (d < 0.0) {
            this.observedPerForm = (double)constraint.evaluateCorpus() / this.dataSize;
            if (this.verbosity > 5) {
                System.out.println("constraint: " + Arrays.toString(constraint.constraint));
                System.out.println("empirical expectation = " + this.observedPerForm);
            }
        } else {
            this.observedPerForm = d;
        }
        if (dArray == null) {
            double[] dArray2 = constraint.sampleViolationProbDistrib();
            this.g = Arrays.copyOf(dArray2, dArray2.length);
        } else {
            this.g = dArray;
        }
        double d2 = this.maximizeObjectiveFunction();
        double d3 = -d2;
        double d4 = this.computeExpectedWeightedPenalty(d3);
        double d5 = d3 * Maxent.scale * this.dataSize * this.observedPerForm + Maxent.scale * this.dataSize * Math.log(d4) + Maxent.dataPlog;
        double d6 = 2.0 * (-d5 - -Maxent.dataPlog);
        if (this.verbosity > 9) {
            System.out.println("\t\tobservedPerForm=" + this.observedPerForm);
            System.out.println("\t\tg=" + Arrays.toString(this.g));
            System.out.println("\t\talpha=" + d3);
            System.out.println("\t\tlambda=" + d6);
        }
        if (d6 < this.CHISQ_CRITICAL) {
            return this.FLOOR;
        }
        double d7 = (1.0 + Maxent.gamma) * d3 * Maxent.scale * this.dataSize * this.observedPerForm + Maxent.scale * this.dataSize * Math.log(d4);
        return -d7;
    }

    void compileViolationCountProbabilities(Constraint constraint) {
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        Arrays.fill(this.g_master, 0.0);
        int n3 = 0;
        for (Map.Entry entry : Maxent.sample.data.entrySet()) {
            nArray = (int[])entry.getKey();
            n = ((Counter)entry.getValue()).value;
            n2 = constraint.evaluate(nArray);
            if (n2 == 0) continue;
            int n4 = n2;
            this.g_master[n4] = this.g_master[n4] + (double)n;
            if (n3 >= n2 + 1) continue;
            n3 = n2 + 1;
        }
        this.g = Arrays.copyOf(this.g_master, n3);
    }

    public void convertCountsToProbabilities() {
        double d = Maxent.sample.size;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0E-20;
        int n = this.g.length;
        for (int i = n - 1; i >= 0; --i) {
            d3 = this.g[i];
            this.g[i] = d3 / d;
            d2 += d3;
        }
        this.g[0] = 1.0 - d2;
        if (this.verbosity > 5) {
            System.out.println("g = " + Arrays.toString(this.g));
        }
    }

    double maximizeObjectiveFunction() {
        double d = -20.0;
        if (this.observedPerForm == 0.0) {
            return d;
        }
        double d2 = 1.0E-4;
        double d3 = 200.0;
        double d4 = 0.1;
        double d5 = -0.1;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = 0;
        while ((double)n <= d3 && !(Math.abs((d5 = d6 - d4 * ((d8 = this.gainDeriv1(this.g, this.observedPerForm, d7 = Math.exp(d5))) / (d9 = this.gainDeriv2(this.g, d7)))) - d6) < d2)) {
            d6 = d5;
            if (this.verbosity > 5) {
                System.out.println("\t\td1 = " + d8);
                System.out.println("\t\td2 = " + d9);
                System.out.println("\t\talpha = " + d5);
            }
            ++n;
        }
        if (d5 > 0.0) {
            return this.FLOOR;
        }
        if (this.verbosity > 5) {
            System.out.println("\t\talpha = " + d5);
        }
        return d5;
    }

    double computeExpectedWeightedPenalty(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.g.length;
        for (int i = n - 1; i >= 0; --i) {
            d2 = this.g[i];
            if (i == 0) {
                d3 += d2;
                continue;
            }
            d3 += d2 * Math.exp(-d * (double)i);
        }
        return d3;
    }

    double gainDeriv1(double[] dArray, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d5 = dArray[i] * d6;
            d3 += (double)i * d5;
            d4 += d5;
            d6 *= d2;
        }
        double d7 = (1.0 + Maxent.gamma) * d - d3 / d4;
        return d7;
    }

    double gainDeriv2(double[] dArray, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d5 = dArray[i] * d6;
            d2 += d5;
            d3 += d5 * (double)i;
            d4 += d5 * (double)i * (double)i;
            d6 *= d;
        }
        double d7 = -(d4 / d2 - d3 / d2 * (d3 / d2));
        return d7;
    }

    @Override
    public double compare(double d, double d2) {
        if (d < d2) {
            return 1.0;
        }
        if (d > d2) {
            return -1.0;
        }
        return 0.0;
    }

    public static void main(String[] stringArray) throws Exception {
        LikelihoodAndEnergyBasedConstraintEvaluator likelihoodAndEnergyBasedConstraintEvaluator = new LikelihoodAndEnergyBasedConstraintEvaluator();
        double d = 2.837748344370861;
        likelihoodAndEnergyBasedConstraintEvaluator.setObservedPerForm(d);
        likelihoodAndEnergyBasedConstraintEvaluator.setG(new double[]{0.0, 0.16208, 0.16514, 0.33646, 0.33632});
        double d2 = likelihoodAndEnergyBasedConstraintEvaluator.maximizeObjectiveFunction();
        System.out.println("alpha = " + d2);
        double d3 = -d2;
        double d4 = likelihoodAndEnergyBasedConstraintEvaluator.computeExpectedWeightedPenalty(d3);
        System.out.println("E = " + d4);
        double d5 = 6040.0;
        double d6 = d3 * d5 * d + d5 * Math.log(d4);
        System.out.println("negLogProbD = " + d6);
        double d7 = d3 * d5 * d + d5 * Math.log(d4);
        d7 = -d7;
        System.out.println("value = " + d7);
    }
}

