/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.maxent.Regularizer;
import java.util.Arrays;

public class L2Regularizer
implements Regularizer {
    private static final double PI = Math.PI;
    public double MU = 0.0;
    public double SIGMA2 = 1.0;
    private double SIGMA = 1.0;

    L2Regularizer() {
        this.MU = 0.0;
        this.SIGMA2 = 1.0;
        this.SIGMA = Math.pow(this.SIGMA2, 0.5);
        System.out.println("l2 (Gaussian) regularizer: mu=" + this.MU + " sigma^2=" + this.SIGMA2);
    }

    L2Regularizer(double d, double d2) {
        this.MU = d;
        this.SIGMA2 = d2;
        this.SIGMA = Math.pow(this.SIGMA2, 0.5);
        System.out.println("l2 (Gaussian) regularizer: mu=" + this.MU + " sigma^2=" + this.SIGMA2);
    }

    @Override
    public double logValue(double[] dArray) {
        double d = 0.0;
        double d2 = Math.log(Math.pow(Math.PI * 2, 0.5) * this.SIGMA);
        for (int i = dArray.length - 1; i >= 0; --i) {
            d += -Math.pow(dArray[i] - this.MU, 2.0) / (2.0 * this.SIGMA2) - d2;
        }
        return -d;
    }

    @Override
    public double[] grad(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = (dArray[i] - this.MU) / this.SIGMA2;
        }
        return dArray2;
    }

    @Override
    public double[] grad(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = (dArray[i] - this.MU) / this.SIGMA2;
        }
        return dArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        L2Regularizer l2Regularizer = new L2Regularizer(0.0, 100.0);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        System.out.println(l2Regularizer.logValue(dArray));
        System.out.println(Arrays.toString(l2Regularizer.grad(dArray)));
    }
}

