/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.GenericBestPath;
import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.LogSemiring;
import edu.ucla.fsm.RealSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import edu.ucla.fsm.WeightMapper;
import edu.ucla.fsm.WeightPush;
import edu.ucla.maxent.WeightMapper_ScoreToProb;
import edu.ucla.maxent.WeightMapper_ViolationsToScore;
import edu.ucla.util.DiscreteDistribution;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class GraphSampler {
    static StateIterator stateiter = new StateIterator();
    static MersenneTwister mt = null;
    static Uniform uniform = null;
    static DiscreteDistribution empirical = null;
    static double[][] transitionCosts = null;
    static int[][] transitionLabels = null;
    static int[][] transitionDests = null;
    static FSM G = null;
    static int initialStateId = 0;
    static int MAXIMUM_SAMPLE_LENGTH = 100;
    static int verbosity = 0;
    public static int[] sample = new int[MAXIMUM_SAMPLE_LENGTH];
    public static int sampleLength = 0;

    GraphSampler() {
        mt = new MersenneTwister(new Date());
        uniform = new Uniform(0.0, 1.0, (RandomEngine)mt);
        empirical = new DiscreteDistribution(mt);
    }

    public void init(FSM fSM, double[] dArray, double d) {
        G = fSM.copy();
        G.mapWeights((WeightMapper)new WeightMapper_ViolationsToScore(dArray));
        WeightPush.apply((FSM)G, (Semiring)new LogSemiring(), (double)d);
        G.mapWeights((WeightMapper)new WeightMapper_ScoreToProb());
        int n = G.renameStates();
        initialStateId = GraphSampler.G.initials.iterator().next();
        transitionCosts = new double[n][];
        transitionLabels = new int[n][];
        transitionDests = new int[n][];
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList arrayList = null;
        stateiter.init(GraphSampler.G.transitions);
        while (stateiter.hasNext()) {
            n3 = stateiter.next();
            arrayList = (ArrayList)GraphSampler.G.transitions.get(n3);
            if (arrayList == null) continue;
            n2 = arrayList.size();
            GraphSampler.transitionCosts[n3] = new double[n2];
            GraphSampler.transitionLabels[n3] = new int[n2];
            GraphSampler.transitionDests[n3] = new int[n2];
            n4 = 0;
            for (Transition transition : arrayList) {
                GraphSampler.transitionCosts[n3][n4] = ((RealWeight)transition.weight).doubleValue();
                GraphSampler.transitionLabels[n3][n4] = transition.input;
                GraphSampler.transitionDests[n3][n4] = transition.dest;
                ++n4;
            }
        }
        if (verbosity > 5) {
            System.out.println("transitionCosts: " + Arrays.toString(transitionCosts[n3]));
            System.out.println("transitionLabels: " + Arrays.toString(transitionLabels[n3]));
            System.out.println("transitionDests: " + Arrays.toString(transitionDests[n3]));
        }
    }

    public void sample() {
        int n = initialStateId;
        int n2 = 0;
        for (sampleLength = 0; sampleLength < MAXIMUM_SAMPLE_LENGTH && transitionDests[n] != null; ++sampleLength) {
            n2 = empirical.nextInt(transitionCosts[n]);
            GraphSampler.sample[GraphSampler.sampleLength] = transitionLabels[n][n2];
            n = transitionDests[n][n2];
        }
        if (verbosity > 5) {
            System.out.print("sample: ");
            for (int i = 0; i < sampleLength; ++i) {
                System.out.print(sample[i] + " ");
            }
            System.out.println();
        }
        if (sample[0] != 0 || sample[sampleLength - 1] != 0) {
            System.out.println("*** Error: GraphSampler.sample() failed to enforce word boundaries");
            System.out.println(G);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        FSM fSM = new FSM();
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        fSM.addInitialState(n);
        fSM.addFinalState(n4);
        fSM.addTransition(new Transition(n, 0, (Weight)new LexicographicWeight(new int[]{1, 0, 0}), n2));
        fSM.addTransition(new Transition(n, 0, (Weight)new LexicographicWeight(new int[]{1, 1, 0}), n3));
        fSM.addTransition(new Transition(n2, 1, (Weight)new LexicographicWeight(new int[]{1, 1, 0}), n3));
        fSM.addTransition(new Transition(n3, 2, (Weight)new LexicographicWeight(new int[]{1, 0, 1}), n2));
        fSM.addTransition(new Transition(n2, 0, (Weight)new LexicographicWeight(new int[]{1, 1, 1}), n4));
        fSM.addTransition(new Transition(n3, 0, (Weight)new LexicographicWeight(new int[]{1, 0, 0}), n4));
        System.out.println(fSM);
        double[] dArray = new double[]{-0.5, -1.0, -1.5};
        FSM fSM2 = fSM.copy();
        fSM2.mapWeights((WeightMapper)new WeightMapper_ViolationsToScore(dArray));
        System.out.println(fSM2);
        fSM2.reverse();
        System.out.println(fSM2);
        GenericBestPath.apply((FSM)fSM2, (Semiring)new RealSemiring(), (double)1.0E-30);
        TIntObjectHashMap tIntObjectHashMap = GenericBestPath.d;
        System.out.println(tIntObjectHashMap);
        Object object = tIntObjectHashMap.get(fSM2.finals.iterator().next());
        System.out.println(object);
        fSM2.reverse();
        System.out.println(fSM2);
        FSM fSM3 = fSM2.copy();
        stateiter.init(fSM3.transitions);
        while (stateiter.hasNext()) {
            int n5 = stateiter.next();
            double d = 0.0;
            for (Transition transition : (ArrayList)fSM3.transitions.get(n5)) {
                transition.weight = new RealWeight(((RealWeight)transition.weight).doubleValue() * ((RealWeight)tIntObjectHashMap.get(transition.dest)).doubleValue());
                d += ((RealWeight)transition.weight).doubleValue();
            }
            for (Transition transition : (ArrayList)fSM3.transitions.get(n5)) {
                transition.weight = new RealWeight(((RealWeight)transition.weight).doubleValue() / d);
            }
        }
        System.out.println(fSM3);
        GenericBestPath.apply((FSM)fSM3, (Semiring)new RealSemiring(), (double)1.0E-30);
        TIntObjectHashMap tIntObjectHashMap2 = GenericBestPath.d;
        System.out.println(tIntObjectHashMap2);
        System.exit(0);
        GraphSampler graphSampler = new GraphSampler();
        graphSampler.init(fSM, dArray, 1.0E-10);
        graphSampler.sample();
        System.out.println(Arrays.toString(sample));
    }
}

