/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import com.infomata.data.DataFile;
import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import com.infomata.data.TabFormat;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FSMQuick;
import edu.ucla.fsm.GenericBestPath;
import edu.ucla.fsm.IntegerLabel;
import edu.ucla.fsm.IntegerWeight;
import edu.ucla.fsm.Intersect;
import edu.ucla.fsm.LogSemiring;
import edu.ucla.fsm.RealSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.StatePair;
import edu.ucla.fsm.SubsetDeterminization;
import edu.ucla.fsm.SymbolTable;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionFactory;
import edu.ucla.fsm.TransitionIterator;
import edu.ucla.fsm.Weight;
import edu.ucla.fsm.WeightFactory;
import edu.ucla.fsm.WeightFactory_Sum;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.Maxent;
import edu.ucla.util.CommandlineParser;
import edu.ucla.util.SimpleFileReader;
import gnu.trove.TIntObjectIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;
import pal.math.OrthogonalHints;

public class GenerativeModelSpellingErrors {
    static int[] CVstatus = null;
    static IntegerLabel[][] targetString = null;
    static FSM G = null;
    static FSMQuick Gquick = null;
    static FSM[] responseFSM = null;
    static FSM[] neighborFSM = null;
    static TransitionFactory F = new TransitionFactory();
    static boolean USE_ORTHOTACTIC_GRAMMAR = true;
    static boolean SINGLE_SUBSTITUTION_NEIGHBORHOOD = false;
    static boolean ALLOW_DELETION = false;

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        FSM fSM;
        Object object2;
        Object object3;
        FSM fSM2;
        Maxent maxent = new Maxent();
        Maxent.main(stringArray);
        CVstatus = new int[Maxent.alphabet.number_of_segments];
        int n6 = 0;
        while (true) {
            if (n6 >= Maxent.alphabet.number_of_segments) break;
            GenerativeModelSpellingErrors.CVstatus[n6] = Maxent.alphabet.feature_matrix[n6][1];
            ++n6;
        }
        System.out.println("CVstatus: " + Arrays.toString(CVstatus));
        if (USE_ORTHOTACTIC_GRAMMAR) {
            System.out.println("Building orthotactic grammar ...");
            FSM fSM3 = FSM.boundedSigmaStarAcceptor((SymbolTable)Maxent.alphabet.symbolTable);
            fSM2 = fSM3.copy();
            object3 = new WeightFactory_Sum();
            int n7 = 0;
            while (true) {
                if (n7 >= Maxent.model.constraintList.size()) break;
                System.out.println("Adding constraint " + (n7 + 1) + "/" + Maxent.model.constraintList.size());
                object2 = Maxent.model.constraintList.get(n7);
                fSM = Maxent.model.compileConstraint((Constraint)object2, false);
                TIntObjectIterator tIntObjectIterator = fSM.transitions.iterator();
                while (tIntObjectIterator.hasNext()) {
                    tIntObjectIterator.advance();
                    for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                        transition.weight = new RealWeight(Maxent.model.lambda[n7] * (double)((IntegerWeight)transition.weight).intValue());
                    }
                }
                fSM2 = Intersect.apply((FSM)fSM, (FSM)fSM2, (TransitionFactory)F.match(1).inputFrom(1).outputFrom(1).weightFactory((WeightFactory)object3));
                fSM2.prune().renameStates();
                fSM2 = SubsetDeterminization.apply((FSM)fSM2);
                ++n7;
            }
            fSM2.proj1to2();
            Gquick = new FSMQuick(fSM2, (Semiring)new RealSemiring());
        }
        CommandlineParser commandlineParser = new CommandlineParser();
        commandlineParser.addOption("errors", true, "file containing error data with rows in the form <target, response, previous.response>");
        fSM2 = SimpleFileReader.apply((String)stringArray[0]);
        commandlineParser.parse((String[])fSM2);
        object3 = new LinkedList();
        LinkedList<String> linkedList = new LinkedList<String>();
        object2 = new LinkedList();
        if (commandlineParser.hasOption("errors")) {
            fSM = DataFile.createReader((String)"8859_1");
            fSM.setDataFormat((DataFormat)new TabFormat());
            fSM.open(new File(commandlineParser.getOptionValue("errors")));
            boolean bl = true;
            object = fSM.next();
            while (object != null) {
                if (bl) {
                    bl = false;
                } else {
                    ((LinkedList)object3).add(object.getString(0));
                    linkedList.add(object.getString(1));
                    ((LinkedList)object2).add(object.getString(2));
                }
                object = fSM.next();
            }
        }
        targetString = new IntegerLabel[((LinkedList)object3).size()][];
        fSM = new FSM[((LinkedList)object3).size()];
        for (n5 = 0; n5 < ((LinkedList)object3).size(); ++n5) {
            System.out.println("target: " + (String)((LinkedList)object3).get(n5));
            object = Maxent.alphabet.encodeString((String)((LinkedList)object3).get(n5), "\\B");
            GenerativeModelSpellingErrors.targetString[n5] = new IntegerLabel[((DataRow)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                GenerativeModelSpellingErrors.targetString[n5][i] = new IntegerLabel((int)object[i]);
            }
            fSM[n5] = FSM.linearAcceptor((int[])object);
            fSM[n5].prune().renameStates();
        }
        responseFSM = new FSM[linkedList.size()];
        for (n5 = 0; n5 < linkedList.size(); ++n5) {
            GenerativeModelSpellingErrors.responseFSM[n5] = FSM.linearAcceptor((int[])Maxent.alphabet.encodeString((String)linkedList.get(n5), "\\B"));
            responseFSM[n5].proj1to2();
            int n8 = responseFSM[n5].renameStates();
            for (int i = 0; i < n8; ++i) {
                responseFSM[n5].addTransition(new Transition(i, -1, -1, null, i));
            }
        }
        System.out.println("Making neighborhood transducer ...");
        FSM fSM4 = new FSM();
        if (SINGLE_SUBSTITUTION_NEIGHBORHOOD) {
            n4 = 0;
            n3 = 1;
            n2 = 2;
            n = 3;
            fSM4.addInitialState(n4);
            fSM4.addFinalState(n);
            fSM4.addTransition(new Transition(n4, 0, 0, null, n3));
            int n9 = 1;
            while (true) {
                if (n9 >= Maxent.alphabet.number_of_segments) break;
                fSM4.addTransition(new Transition(n3, n9, n9, null, n3));
                fSM4.addTransition(new Transition(n2, n9, n9, null, n2));
                int n10 = 1;
                while (true) {
                    if (n10 >= Maxent.alphabet.number_of_segments) break;
                    fSM4.addTransition(new Transition(n3, n9, n10, null, n2));
                    ++n10;
                }
                ++n9;
            }
            fSM4.addTransition(new Transition(n3, 0, 0, null, n));
            fSM4.addTransition(new Transition(n2, 0, 0, null, n));
        } else {
            n4 = 0;
            n3 = 1;
            n2 = 2;
            fSM4.addInitialState(n4);
            fSM4.addFinalState(n2);
            fSM4.addTransition(new Transition(n4, 0, 0, null, n3));
            n = 1;
            while (true) {
                if (n >= Maxent.alphabet.number_of_segments) break;
                fSM4.addTransition(new Transition(n3, -1, n, null, n3));
                ++n;
            }
            if (ALLOW_DELETION) {
                fSM4.addTransition(new Transition(n3, -1, -1, null, n3));
            }
            fSM4.addTransition(new Transition(n3, 0, 0, null, n2));
        }
        fSM4.prune().renameStates();
        System.out.println("Making the neighborhood of each target ...");
        neighborFSM = new FSM[((LinkedList)object3).size()];
        for (n4 = 0; n4 < ((FSM)fSM).length; ++n4) {
            System.out.println(n4 + "/" + ((LinkedList)object3).size() + ": " + (String)((LinkedList)object3).get(n4) + " -> " + (String)linkedList.get(n4));
            GenerativeModelSpellingErrors.neighborFSM[n4] = SINGLE_SUBSTITUTION_NEIGHBORHOOD ? Intersect.apply((FSM)fSM[n4], (FSM)fSM4, (TransitionFactory)F.match(1).inputFrom(1).outputFrom(2)) : Intersect.apply((FSM)fSM[n4], (FSM)fSM4, (TransitionFactory)F.match(0).inputFrom(1).outputFrom(2));
            neighborFSM[n4].prune().renameStates();
        }
        for (n4 = 0; n4 < ((FSM)fSM).length; ++n4) {
            System.out.println((String)((LinkedList)object3).get(n4) + " -> " + (String)linkedList.get(n4));
            GenerativeModelSpellingErrors.responseFSM[n4] = Intersect.apply((FSM)neighborFSM[n4], (FSM)responseFSM[n4], (TransitionFactory)F.match(2).inputFrom(1).outputFrom(2));
            responseFSM[n4].prune().renameStates();
            if (!GenerativeModelSpellingErrors.responseFSM[n4].initials.isEmpty() && !GenerativeModelSpellingErrors.responseFSM[n4].finals.isEmpty()) continue;
            GenerativeModelSpellingErrors.responseFSM[n4] = null;
        }
        GenerativeModelSpellingErrors generativeModelSpellingErrors = new GenerativeModelSpellingErrors();
        generativeModelSpellingErrors.optimize();
    }

    public void optimize() {
        int n = 4;
        F f = new F(targetString, responseFSM, neighborFSM, Gquick, n);
        double[] dArray = new double[n];
        Arrays.fill(dArray, 1.0);
        ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
        conjugateDirectionSearch.step = 0.25;
        conjugateDirectionSearch.maxFun = 500;
        conjugateDirectionSearch.numFuncStops = 500;
        conjugateDirectionSearch.prin = 0;
        conjugateDirectionSearch.optimize((MultivariateFunction)f, dArray, Double.MIN_VALUE, Double.MIN_VALUE, null);
        System.out.println("beta_opt (ortho,sub,del,C/V) = " + Arrays.toString(dArray));
        System.out.println("logProb  = " + f.evaluate(dArray));
    }

    static double totalWeight(FSM fSM, FSMQuick fSMQuick, double[] dArray) {
        StateIterator stateIterator = new StateIterator();
        StateIterator stateIterator2 = new StateIterator();
        TransitionIterator transitionIterator = new TransitionIterator();
        TransitionIterator transitionIterator2 = new TransitionIterator();
        int n = fSMQuick.transitions.length;
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        int n2 = fSM.renameStates();
        boolean[][] blArray = new boolean[n2][n];
        double[][] dArray2 = new double[n2][n];
        boolean[][] blArray2 = new boolean[n2][n];
        StatePair statePair = null;
        stateIterator.init(fSM.initials);
        while (stateIterator.hasNext()) {
            int n3 = stateIterator.next();
            stateIterator2.init(fSMQuick.initials);
            while (stateIterator2.hasNext()) {
                int n4 = stateIterator2.next();
                statePair = new StatePair(n3, n4);
                linkedList.add(statePair);
                blArray[statePair.left][statePair.right] = true;
                dArray2[statePair.left][statePair.right] = 0.0;
                blArray2[statePair.left][statePair.right] = true;
            }
        }
        StatePair statePair2 = null;
        Transition transition = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (!linkedList.isEmpty()) {
            statePair = (StatePair)linkedList.remove(0);
            blArray[statePair.left][statePair.right] = false;
            d = dArray2[statePair.left][statePair.right];
            transitionIterator.init(fSM.transitions, statePair.left);
            while (transitionIterator.hasNext()) {
                transition = transitionIterator.next();
                if (transition.output == -1) {
                    d3 = GenerativeModelSpellingErrors.getCost(transition.input, transition.output, null, dArray);
                    statePair2 = new StatePair(transition.dest, statePair.right);
                    d2 = blArray2[statePair2.left][statePair2.right] ? Math.log(Math.exp(dArray2[statePair2.left][statePair2.right]) + Math.exp(d) * Math.exp(d3)) : d + d3;
                    dArray2[statePair2.left][statePair2.right] = d2;
                    blArray2[statePair2.left][statePair2.right] = true;
                    if (blArray[statePair2.left][statePair2.right]) continue;
                    linkedList.add(statePair2);
                    blArray[statePair2.left][statePair2.right] = true;
                    continue;
                }
                for (Transition transition2 : fSMQuick.transitions[statePair.right]) {
                    if (transition2.output != transition.output) continue;
                    d3 = GenerativeModelSpellingErrors.getCost(transition.input, transition.output, transition2.weight, dArray);
                    statePair2 = new StatePair(transition.dest, transition2.dest);
                    d2 = blArray2[statePair2.left][statePair2.right] ? Math.log(Math.exp(dArray2[statePair2.left][statePair2.right]) + Math.exp(d) * Math.exp(d3)) : d + d3;
                    dArray2[statePair2.left][statePair2.right] = d2;
                    blArray2[statePair2.left][statePair2.right] = true;
                    if (blArray[statePair2.left][statePair2.right]) continue;
                    linkedList.add(statePair2);
                    blArray[statePair2.left][statePair2.right] = true;
                }
            }
        }
        double d4 = 0.0;
        int n5 = 1;
        stateIterator.init(fSM.finals);
        while (stateIterator.hasNext()) {
            stateIterator2.init(fSMQuick.finals);
            while (stateIterator2.hasNext()) {
                statePair = new StatePair(stateIterator.next(), stateIterator2.next());
                if (!blArray2[statePair.left][statePair.right]) continue;
                if (n5 != 0) {
                    d4 = dArray2[statePair.left][statePair.right];
                    n5 = 0;
                    continue;
                }
                d4 = Math.log(Math.exp(d4) + Math.exp(dArray2[statePair.left][statePair.right]));
            }
        }
        return d4;
    }

    static double totalWeight(FSM fSM, double[] dArray) {
        TIntObjectIterator tIntObjectIterator = fSM.transitions.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.weight = new RealWeight(-GenerativeModelSpellingErrors.getCost(transition.input, transition.output, null, dArray));
            }
        }
        tIntObjectIterator = (RealWeight)GenericBestPath.apply((FSM)fSM, (Semiring)new LogSemiring());
        return -tIntObjectIterator.doubleValue();
    }

    static double getCost(int n, int n2, Weight weight, double[] dArray) {
        double d = 0.0;
        if (weight != null) {
            d += -dArray[0] * ((RealWeight)weight).doubleValue();
        }
        if (n != n2 && n2 != -1) {
            d += -dArray[1];
        }
        if (n != n2 && n2 == -1) {
            d += -dArray[2];
        }
        if (n2 != -1 && CVstatus[n2] != CVstatus[n]) {
            d += -dArray[3];
        }
        return d;
    }

    class F
    implements MultivariateFunction {
        IntegerLabel[][] targetString = null;
        FSM[] responseFSM = null;
        FSM[] neighborFSM = null;
        FSMQuick G = null;
        Transition[][] Gtrans = null;
        int N = 0;
        double WEIGHT_LOWER_BOUND = 0.0;
        double WEIGHT_UPPER_BOUND = Double.MAX_VALUE;
        int iteration = 0;

        F(IntegerLabel[][] integerLabelArray, FSM[] fSMArray, FSM[] fSMArray2, FSMQuick fSMQuick, int n) {
            this.targetString = integerLabelArray;
            this.responseFSM = fSMArray;
            this.neighborFSM = fSMArray2;
            this.G = fSMQuick;
            this.N = n;
        }

        public int getNumArguments() {
            return this.N;
        }

        public double getLowerBound(int n) {
            return this.WEIGHT_LOWER_BOUND;
        }

        public double getUpperBound(int n) {
            return this.WEIGHT_UPPER_BOUND;
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }

        public double evaluate(double[] dArray) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < this.responseFSM.length; ++i) {
                if (this.responseFSM[i] == null) continue;
                d2 = this.G == null ? GenerativeModelSpellingErrors.totalWeight(this.responseFSM[i], dArray) : GenerativeModelSpellingErrors.totalWeight(this.responseFSM[i], this.G, dArray);
                d3 = this.G == null ? GenerativeModelSpellingErrors.totalWeight(this.neighborFSM[i], dArray) : GenerativeModelSpellingErrors.totalWeight(this.neighborFSM[i], this.G, dArray);
                d += -(d2 - d3);
                if (i % 100 != 0) continue;
                System.out.print(". ");
            }
            System.out.println();
            if (this.iteration % 1 == 0) {
                System.out.println(Arrays.toString(dArray) + ", " + d);
            }
            ++this.iteration;
            return d;
        }
    }

    private static enum Cost {
        subst,
        del,
        ortho,
        CVpres;

    }
}

