/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.maxent.Regularizer;
import java.util.Arrays;

public class GaussianGeneralityRegularizer
implements Regularizer {
    private static final double PI = Math.PI;
    public double MU = 0.0;
    public double c = 0.0;
    public double[] SIGMA = null;
    public double[] SIGMA2 = null;

    GaussianGeneralityRegularizer() {
        this.MU = 0.0;
        this.c = 0.0;
        System.out.println("Gaussian generality regularizer: mu=" + this.MU + " c=" + this.c);
    }

    GaussianGeneralityRegularizer(double d, double d2) {
        this.MU = d;
        this.c = d2;
        System.out.println("Gaussian generality regularizer: mu=" + this.MU + " c=" + this.c);
    }

    public void update(double[] dArray) {
        int n = dArray.length;
        this.SIGMA2 = new double[n];
        this.SIGMA = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            this.SIGMA2[i] = this.c * dArray[i];
            this.SIGMA[i] = Math.pow(this.SIGMA2[i], 0.5);
        }
        System.out.println("sigma2 = " + Arrays.toString(this.SIGMA2));
    }

    @Override
    public double logValue(double[] dArray) {
        double d = 0.0;
        for (int i = dArray.length - 1; i >= 0; --i) {
            d += Math.log(1.0 / (Math.pow(Math.PI * 2, 0.5) * this.SIGMA[i])) - Math.pow(dArray[i] - this.MU, 2.0) / (2.0 * this.SIGMA2[i]);
        }
        return d;
    }

    @Override
    public double[] grad(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = (dArray[i] - this.MU) / this.SIGMA2[i];
        }
        return dArray2;
    }

    @Override
    public double[] grad(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = (dArray[i] - this.MU) / this.SIGMA2[i];
        }
        return dArray2;
    }
}

