/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.maxent.Regularizer;
import java.util.Arrays;

public class ExponentialRegularizer
implements Regularizer {
    private static final double PI = Math.PI;
    public double ALPHA = 1.0;
    public double LOG_ALPHA = 0.0;

    ExponentialRegularizer() {
        this.ALPHA = 1.0;
        this.LOG_ALPHA = Math.log(this.ALPHA);
        System.out.println("Exponential regularizer: alpha=" + this.ALPHA);
    }

    ExponentialRegularizer(double d) {
        this.ALPHA = d;
        this.LOG_ALPHA = Math.log(this.ALPHA);
        System.out.println("Exponential regularizer: alpha=" + this.ALPHA);
    }

    @Override
    public double logValue(double[] dArray) {
        double d = 0.0;
        d += (double)dArray.length * this.LOG_ALPHA;
        for (double d2 : dArray) {
            d -= this.ALPHA * d2;
        }
        return -d;
    }

    @Override
    public double[] grad(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = this.ALPHA;
        }
        return dArray2;
    }

    @Override
    public double[] grad(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = this.ALPHA;
        }
        return dArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        ExponentialRegularizer exponentialRegularizer = new ExponentialRegularizer(1.0);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        System.out.println(exponentialRegularizer.logValue(dArray));
        System.out.println(Arrays.toString(exponentialRegularizer.grad(dArray)));
    }
}

