/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Projection;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.ConstraintFilter;

public class DefaultConstraintFilter
extends ConstraintFilter {
    int maxFeaturesPerClass = -1;
    int maxSegmentsPerClass = -1;

    public DefaultConstraintFilter() {
    }

    public DefaultConstraintFilter(int n, int n2) {
        this.maxFeaturesPerClass = n;
        this.maxSegmentsPerClass = n2;
    }

    @Override
    public boolean apply(Constraint constraint) {
        return this.apply(constraint.projection, constraint.classIndex);
    }

    @Override
    public boolean apply(Projection projection, int[] nArray) {
        int n;
        int n2;
        if (nArray == null) {
            return true;
        }
        if (nArray.length == 1 && nArray[0] == 0) {
            return false;
        }
        for (n2 = 1; n2 < nArray.length - 1; ++n2) {
            if (nArray[n2] != 0) continue;
            return false;
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (!projection.alphabet.complementStatus[nArray[n]] || ++n2 <= 1) continue;
            return false;
        }
        if (this.maxFeaturesPerClass != -1) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 0 || nArray[n] == 1 || projection.alphabet.naturalClassFeatureSizes[nArray[n]] <= this.maxFeaturesPerClass) continue;
                return false;
            }
        }
        if (this.maxSegmentsPerClass != -1) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 0 || nArray[n] == 1 || projection.alphabet.naturalClassDenotationSizes[nArray[n]] <= this.maxSegmentsPerClass) continue;
                return false;
            }
        }
        return true;
    }
}

