/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Projection;
import edu.ucla.maxent.ConstraintFilter;
import edu.ucla.util.BinaryRelation;
import edu.ucla.util.BreadthFirstIterator;
import edu.ucla.util.IntArrayComparator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CorpusBasedPrepruner4 {
    static IntArrayComparator INT_ARRAY_COMPARATOR = new IntArrayComparator();
    static String LEFT_CONTEXT = new String("left_context");
    static String RIGHT_CONTEXT = new String("right_context");
    public Projection projection = null;
    public ConstraintFilter filter = null;
    public int maxGramSize = 0;
    public LinkedList<TreeSet<int[]>> S = null;
    BinaryRelation naturalClassLattice = null;
    BinaryRelation naturalClassLatticeInv = null;
    BinaryRelation naturalClassTree = null;
    BitSet[] classSet = null;
    int[] singletonClassIndex = null;
    HashMap<BitSet, BitSet> nonzeroSegmentsCache = new HashMap();
    HashMap<BitSet, BitSet> unblockedClassesCache = new HashMap();

    public CorpusBasedPrepruner4(Projection projection, ConstraintFilter constraintFilter) {
        Object object;
        int n;
        this.projection = projection;
        this.filter = constraintFilter;
        this.maxGramSize = projection.maxGramSize;
        int n2 = projection.alphabet.number_of_natural_classes;
        this.naturalClassLattice = new BinaryRelation();
        for (n = 0; n < projection.alphabet.number_of_natural_classes; ++n) {
            this.naturalClassLattice.add(Integer.valueOf(n));
            if (projection.naturalClassGraphInt[n] == null) continue;
            for (int n3 : projection.naturalClassGraphInt[n]) {
                this.naturalClassLattice.add(Integer.valueOf(n), Integer.valueOf(n3));
            }
        }
        this.naturalClassLattice = this.naturalClassLattice.transReduc();
        for (n = 0; n < n2; ++n) {
            object = new BitSet(n2);
            for (int n4 : projection.alphabet.naturalClassSegments[n]) {
                ((BitSet)object).set(n4);
            }
            Object object2 = this.naturalClassLattice.get(Integer.valueOf(n)).keySet().iterator();
            while (object2.hasNext()) {
                int n5 = (Integer)object2.next();
                BitSet bitSet = (BitSet)((BitSet)object).clone();
                for (int n6 : projection.alphabet.naturalClassSegments[n5]) {
                    bitSet.clear(n6);
                }
                this.naturalClassLattice.add(Integer.valueOf(n), Integer.valueOf(n5), (Object)bitSet);
            }
        }
        this.naturalClassLatticeInv = this.naturalClassLattice.inverse();
        this.naturalClassTree = new BinaryRelation();
        for (n = 0; n < n2; ++n) {
            this.naturalClassTree.add(Integer.valueOf(n));
        }
        for (n = 0; n < n2; ++n) {
            object = null;
            int n7 = Integer.MAX_VALUE;
            for (Map.Entry entry : this.naturalClassLatticeInv.get(Integer.valueOf(n)).entrySet()) {
                int n8 = (Integer)entry.getKey();
                if (projection.alphabet.naturalClassDenotationSizes[n8] >= n7) continue;
                object = entry;
                n7 = projection.alphabet.naturalClassDenotationSizes[n8];
            }
            if (object == null) continue;
            this.naturalClassTree.add((Integer)object.getKey(), Integer.valueOf(n), object.getValue());
        }
        this.classSet = new BitSet[n2];
        for (n = 0; n < n2; ++n) {
            this.classSet[n] = projection.alphabet.naturalClassSets[n];
        }
        this.singletonClassIndex = new int[projection.alphabet.number_of_segments];
        for (n = 0; n < n2; ++n) {
            if (projection.alphabet.naturalClassDenotationSizes[n] != 1) continue;
            this.singletonClassIndex[projection.alphabet.naturalClassSegments[n][0]] = n;
        }
        this.S = new LinkedList();
        TreeSet<int[]> treeSet = new TreeSet<int[]>((Comparator<int[]>)INT_ARRAY_COMPARATOR);
        object = this.nonzeroSegments(new int[0], LEFT_CONTEXT);
        BitSet bitSet = this.unblockedClasses((BitSet)object);
        int n9 = bitSet.nextSetBit(0);
        while (n9 != -1) {
            treeSet.add(new int[]{n9});
            n9 = bitSet.nextSetBit(n9 + 1);
        }
        this.S.add(treeSet);
        System.out.println("size of S1: " + treeSet.size());
        for (n9 = 2; n9 <= projection.maxGramSize; ++n9) {
            System.out.println("pruning constraints of size " + n9 + " ...");
            TreeSet<int[]> treeSet2 = this.pruneInLeftContext(this.S.get(n9 - 2), n9);
            for (int i = 0; i < n9 - 1; ++i) {
                treeSet2 = this.pruneInContext(treeSet2, n9, i);
            }
            this.S.add(treeSet2);
            System.out.println("size of S" + n9 + ": " + treeSet2.size());
        }
    }

    public BitSet nonzeroSegments(int[] nArray, String string) {
        int n;
        int n2 = nArray.length;
        BitSet[] bitSetArray = new BitSet[n2 + 1];
        int n3 = 0;
        if (string == LEFT_CONTEXT) {
            for (n = 0; n < n2; ++n) {
                bitSetArray[n] = this.projection.alphabet.naturalClassSets[nArray[n]];
            }
            n3 = n2;
        } else if (string == RIGHT_CONTEXT) {
            for (n = 1; n <= n2; ++n) {
                bitSetArray[n] = this.projection.alphabet.naturalClassSets[nArray[n - 1]];
            }
            n3 = 0;
        }
        n = this.projection.alphabet.number_of_segments;
        BitSet bitSet = new BitSet(n);
        for (int i = n - 1; i >= 0; --i) {
            bitSetArray[n3] = this.projection.alphabet.naturalClassSets[this.singletonClassIndex[i]];
            if (!this.projection.corpusIndexer.exists(bitSetArray)) continue;
            bitSet.set(i);
        }
        BitSet bitSet2 = this.nonzeroSegmentsCache.get(bitSet);
        if (bitSet2 == null) {
            this.nonzeroSegmentsCache.put(bitSet, bitSet);
            return bitSet;
        }
        return bitSet2;
    }

    public BitSet unblockedClasses(BitSet bitSet) {
        if (this.unblockedClassesCache.containsKey(bitSet)) {
            return this.unblockedClassesCache.get(bitSet);
        }
        int n = this.projection.alphabet.number_of_natural_classes;
        BitSet bitSet2 = new BitSet(n);
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = null;
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator();
        breadthFirstIterator.init(this.naturalClassTree);
        Integer n2 = breadthFirstIterator.next();
        while (n2 != null) {
            block7: {
                if (bitSet3.get(n2)) {
                    breadthFirstIterator.prune();
                } else {
                    for (Map.Entry entry : this.naturalClassLatticeInv.get(n2).entrySet()) {
                        bitSet4 = (BitSet)entry.getValue();
                        if (bitSet4.intersects(bitSet)) continue;
                        break block7;
                    }
                    if (!this.classSet[n2].intersects(bitSet)) {
                        for (Map.Entry entry : this.naturalClassLattice.get(n2).keySet()) {
                            bitSet3.set((Integer)((Object)entry));
                        }
                    }
                    bitSet2.set(n2);
                }
            }
            n2 = breadthFirstIterator.next();
        }
        this.unblockedClassesCache.put(bitSet, bitSet2);
        return bitSet2;
    }

    public TreeSet<int[]> pruneInLeftContext(TreeSet<int[]> treeSet, int n) {
        TreeSet<int[]> treeSet2 = new TreeSet<int[]>((Comparator<int[]>)INT_ARRAY_COMPARATOR);
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n - 1];
        for (int[] nArray3 : treeSet) {
            System.arraycopy(nArray3, 0, nArray, 0, n - 1);
            bitSet = this.nonzeroSegments(nArray3, LEFT_CONTEXT);
            bitSet2 = this.unblockedClasses(bitSet);
            int n2 = bitSet2.nextSetBit(0);
            while (n2 != -1) {
                nArray[n - 1] = n2;
                if (this.filter.apply(this.projection, nArray)) {
                    System.arraycopy(nArray, 1, nArray2, 0, n - 1);
                    if (treeSet.contains(nArray2)) {
                        treeSet2.add(Arrays.copyOf(nArray, n));
                    }
                }
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
        return treeSet2;
    }

    public TreeSet<int[]> pruneInContext(TreeSet<int[]> treeSet, int n, int n2) {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n - n2 - 1];
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        TreeMap<int[], BitSet> treeMap = new TreeMap<int[], BitSet>((Comparator<int[]>)INT_ARRAY_COMPARATOR);
        TreeSet<int[]> treeSet2 = new TreeSet<int[]>((Comparator<int[]>)INT_ARRAY_COMPARATOR);
        for (int[] nArray3 : treeSet) {
            System.arraycopy(nArray3, 0, nArray, 0, n2);
            System.arraycopy(nArray3, n2 + 1, nArray2, 0, n - (n2 + 1));
            if (!treeMap.containsKey(nArray)) {
                BitSet bitSet3 = this.nonzeroSegments(nArray, LEFT_CONTEXT);
                bitSet = this.unblockedClasses(bitSet3);
                treeMap.put(Arrays.copyOf(nArray, nArray.length), bitSet);
            } else {
                bitSet = (BitSet)treeMap.get(nArray);
            }
            if (!bitSet.get(nArray3[n2])) continue;
            if (!treeMap.containsKey(nArray2)) {
                BitSet bitSet4 = this.nonzeroSegments(nArray2, RIGHT_CONTEXT);
                bitSet2 = this.unblockedClasses(bitSet4);
                treeMap.put(Arrays.copyOf(nArray2, nArray2.length), bitSet2);
            } else {
                bitSet2 = (BitSet)treeMap.get(nArray2);
            }
            if (!bitSet2.get(nArray3[n2])) continue;
            treeSet2.add(nArray3);
        }
        treeMap.clear();
        return treeSet2;
    }
}

