/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.Projection;
import edu.ucla.fsm.SequenceIndexer;
import edu.ucla.util.IntArrayComparator;
import java.util.Arrays;
import java.util.BitSet;

public class Constraint {
    public Projection projection = null;
    public BitSet[] constraint = null;
    public int[] classIndex = null;
    public int length = -1;
    private int[] window = null;
    private static IntArrayComparator comparator = new IntArrayComparator();
    private int hashCode = 0;

    public Constraint(Projection projection, BitSet[] bitSetArray) {
        this.projection = projection;
        this.constraint = bitSetArray;
        this.classIndex = null;
        this.length = bitSetArray.length;
    }

    public Constraint(Projection projection, int[] nArray) {
        this.projection = projection;
        this.classIndex = nArray;
        this.length = nArray.length;
        this.constraint = new BitSet[this.length];
        for (int i = this.length - 1; i >= 0; --i) {
            this.constraint[i] = projection.alphabet.naturalClassSets[nArray[i]];
        }
    }

    public Constraint(Projection projection, BitSet[] bitSetArray, int[] nArray) {
        this.projection = projection;
        this.constraint = bitSetArray;
        this.classIndex = nArray;
        this.length = bitSetArray.length;
    }

    public Constraint(Projection projection, String string) {
        this.projection = projection;
        String string2 = string.replaceAll("[*]", "");
        String[] stringArray = string2.split("]|}");
        this.length = stringArray.length;
        this.classIndex = new int[this.length];
        this.constraint = new BitSet[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.constraint[i] = projection.stringToSegmentSet(stringArray[i]);
            int n = projection.classIndex(this.constraint[i]);
            this.classIndex[i] = n == -1 ? Integer.MIN_VALUE : n;
        }
    }

    public int evaluate(int[] nArray) {
        if (this.window == null || this.window.length < this.length) {
            this.window = new int[this.length];
        }
        int n = 0;
        int n2 = 0;
        boolean[] blArray = this.projection.segmentMaskBoolean;
        boolean bl = false;
        for (int n3 : nArray) {
            int n4;
            if (blArray != null && !blArray[n3]) continue;
            this.window[n++] = n3;
            if (n < this.length) continue;
            bl = true;
            for (n4 = 0; n4 < this.length; ++n4) {
                if (this.constraint[n4].get(this.window[n4])) continue;
                bl = false;
                break;
            }
            if (bl) {
                ++n2;
            }
            for (n4 = 1; n4 < this.length; ++n4) {
                this.window[n4 - 1] = this.window[n4];
            }
            --n;
        }
        return n2;
    }

    public int evaluateCorpus() {
        return this.evaluate(this.projection.corpus, this.projection.corpusIndexer);
    }

    public int evaluateSample() {
        return this.evaluate(this.projection.sample, this.projection.sampleIndexer);
    }

    public int evaluate(Corpus corpus, SequenceIndexer sequenceIndexer) {
        return sequenceIndexer.getCount(this.constraint);
    }

    public double[] sampleViolationProbDistrib() {
        return this.projection.sampleIndexer.getCountProbDistrib(this.constraint);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Constraint)) {
            return false;
        }
        Constraint constraint = (Constraint)object;
        if (constraint.projection != this.projection) {
            return false;
        }
        return Arrays.equals(this.constraint, constraint.constraint);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = 7;
        for (int i = 0; i < this.length; ++i) {
            this.hashCode += 31 * this.constraint[i].hashCode();
        }
        return this.hashCode;
    }

    public String toRegExpWithSymbols() {
        return this.toRegExp();
    }

    public String toRegExp() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.projection.oneOrMoreSegmentsMasked) {
            stringBuffer.append("(");
            boolean bl = true;
            for (n = 0; n < this.projection.segmentMaskBoolean.length; ++n) {
                if (this.projection.segmentMaskBoolean[n]) continue;
                if (!bl) {
                    stringBuffer.append("|");
                } else {
                    bl = false;
                }
                stringBuffer.append(n);
            }
            stringBuffer.append(")*");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < this.length; ++n) {
            stringBuffer2.append("(");
            boolean bl = true;
            int n2 = this.constraint[n].nextSetBit(0);
            while (n2 != -1) {
                if (this.projection.segmentMaskBoolean == null || this.projection.segmentMaskBoolean[n2]) {
                    if (!bl) {
                        stringBuffer2.append("|");
                    } else {
                        bl = false;
                    }
                    stringBuffer2.append("(");
                    stringBuffer2.append(n2);
                    stringBuffer2.append(")");
                }
                n2 = this.constraint[n].nextSetBit(n2 + 1);
            }
            stringBuffer2.append(")");
            if (n >= this.length - 1 || stringBuffer.equals("")) continue;
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    public String toString() {
        if (this.constraint == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*");
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.projection.segmentSetToString(this.constraint[i]));
        }
        return stringBuffer.toString();
    }

    public Constraint copy() {
        int n = this.classIndex.length;
        int[] nArray = Arrays.copyOf(this.classIndex, n);
        BitSet[] bitSetArray = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            bitSetArray[i] = this.classIndex[i] == Integer.MIN_VALUE ? (BitSet)this.constraint[i].clone() : this.projection.alphabet.naturalClassSets[this.classIndex[i]];
        }
        Constraint constraint = new Constraint(this.projection, bitSetArray, nArray);
        return constraint;
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

