/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.maxent.Regularizer;
import java.util.Arrays;

public class CompositeRegularizer
implements Regularizer {
    Regularizer[] reg;
    double[] coef;
    int N = 0;

    public CompositeRegularizer(Regularizer[] regularizerArray, double[] dArray) {
        this.reg = regularizerArray;
        this.coef = dArray;
        this.N = regularizerArray.length;
    }

    @Override
    public double logValue(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.N; ++i) {
            d += this.coef[i] * this.reg[i].logValue(dArray);
        }
        return d;
    }

    @Override
    public double[] grad(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = null;
        for (int i = 0; i < this.N; ++i) {
            dArray3 = this.reg[i].grad(dArray);
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                dArray2[n2] = dArray2[n2] + this.coef[i] * dArray3[j];
            }
        }
        System.out.println("Regularizer.grad(): " + Arrays.toString(dArray) + " -> " + Arrays.toString(dArray2));
        return dArray2;
    }

    @Override
    public double[] grad(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = null;
        for (int i = 0; i < this.N; ++i) {
            dArray3 = this.reg[i].grad(dArray);
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                dArray2[n2] = dArray2[n2] + this.coef[i] * dArray3[j];
            }
        }
        return dArray2;
    }
}

