/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Projection;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.ConstraintEvaluator;
import edu.ucla.maxent.ConstraintFilter;
import edu.ucla.maxent.LikelihoodAndEnergyBasedConstraintEvaluator;
import edu.ucla.maxent.Maxent;
import edu.ucla.util.CartesianProductIterator;
import edu.ucla.util.IntArrayComparator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;

public class BaselineConstraintSearch4 {
    public static final double MAX_VALUE = Double.MAX_VALUE;
    public static double MAX_WEIGHT = 20.0;
    public ConstraintEvaluator evaluator = null;
    public boolean evaluatorIsGainBased = false;
    public Projection projection = null;
    public int maxGramSize = 0;
    public ConstraintFilter filter = null;
    double bestValue = 0.0;
    Constraint bestConstraint = null;
    double[][] valueBoundCache2 = null;
    double[][] observedPerFormCache2 = null;
    TreeMap<int[], Double> valueBoundCache3 = null;
    TreeMap<int[], Double> observedPerFormCache3 = null;
    int numberOfEvaluations = 0;
    int numberOfEvaluationsToBest = 0;
    int pruningAttempts = 0;
    int pruningApplications = 0;
    int verbosity = 0;

    public BaselineConstraintSearch4(Projection projection, ConstraintEvaluator constraintEvaluator, ConstraintFilter constraintFilter) {
        this.projection = projection;
        this.maxGramSize = projection.maxGramSize;
        this.evaluator = constraintEvaluator;
        this.evaluatorIsGainBased = constraintEvaluator instanceof LikelihoodAndEnergyBasedConstraintEvaluator;
        this.filter = constraintFilter;
        int n = projection.alphabet.number_of_natural_classes;
        this.valueBoundCache2 = new double[n][n];
        this.observedPerFormCache2 = new double[n][n];
        this.valueBoundCache3 = new TreeMap(new IntArrayComparator());
        this.observedPerFormCache3 = new TreeMap(new IntArrayComparator());
    }

    public Constraint apply() {
        LinkedList linkedList = this.projection.searchSpace;
        if (linkedList == null) {
            System.out.println("Error: Null search space on projection " + this.projection + ".\nBaselineConstraintSearch4 cannot be used unless -prePrune is set.");
            System.exit(1);
        }
        this.pruningAttempts = 0;
        this.pruningApplications = 0;
        this.valueBoundCache3.clear();
        this.observedPerFormCache3.clear();
        this.bestValue = this.evaluator.floor();
        this.bestConstraint = null;
        this.numberOfEvaluations = 0;
        this.numberOfEvaluationsToBest = 0;
        TreeSet treeSet = null;
        Constraint constraint = null;
        BitSet[] bitSetArray = null;
        int n = linkedList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = i + 1;
            bitSetArray = new BitSet[n2];
            System.out.println("Searching constraints of length " + n2 + "...");
            treeSet = (TreeSet)linkedList.get(i);
            block1: for (int[] nArray : treeSet) {
                if (n2 > 2) {
                    ++this.pruningAttempts;
                    for (int j = 0; j < n2 - 1; ++j) {
                        if (!(this.valueBoundCache2[nArray[j]][nArray[j + 1]] < this.bestValue) && this.observedPerFormCache2[nArray[j]][nArray[j + 1]] != 0.0) continue;
                        ++this.pruningApplications;
                        continue block1;
                    }
                }
                constraint = new Constraint(this.projection, nArray);
                if (n2 == 2) {
                    this.evaluate2(constraint);
                    continue;
                }
                this.evaluate(constraint);
            }
        }
        System.out.println("\npercent successful pruning = " + (double)this.pruningApplications / (double)this.pruningAttempts * 100.0 + "%");
        if (this.bestConstraint != null) {
            System.out.println();
            System.out.println("bestConstraint: " + this.bestConstraint + " (value = " + this.bestValue + ")");
            return this.bestConstraint;
        }
        return null;
    }

    public void searchAdHocConstraints() {
        int n = this.projection.alphabet.number_of_natural_classes;
        int n2 = this.projection.alphabet.number_of_segments;
        CartesianProductIterator cartesianProductIterator = new CartesianProductIterator();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        BitSet[] bitSetArray = null;
        BitSet bitSet = null;
        BitSet[] bitSetArray2 = null;
        int[] nArray2 = null;
        Constraint constraint = null;
        for (int i = 2; i <= this.projection.maxGramSize; ++i) {
            System.out.println("Searching ad-hoc constraints of length " + i + "...");
            bitSetArray = new BitSet[i - 1];
            bitSetArray2 = new BitSet[i];
            nArray2 = new int[i];
            int[][] nArrayArray = new int[i - 1][];
            for (int j = 0; j < i - 1; ++j) {
                nArrayArray[j] = nArray;
            }
            cartesianProductIterator.init((int[][])nArrayArray);
            int[] nArray3 = cartesianProductIterator.next();
            while (nArray3 != null) {
                int n3;
                for (n3 = 0; n3 < i - 1; ++n3) {
                    bitSetArray[n3] = this.projection.alphabet.naturalClassSets[nArray3[n3]];
                }
                for (n3 = 0; n3 < i; ++n3) {
                    int n4;
                    bitSet = this.projection.getSegsObservedInContext(bitSetArray, n3);
                    bitSet.flip(0, n2);
                    bitSet.clear(0);
                    if (this.projection.segmentMask != null) {
                        bitSet.and(this.projection.segmentMask);
                    }
                    int n5 = this.projection.classIndex(bitSet);
                    if (bitSet.isEmpty() || n5 != -1) continue;
                    for (n4 = 0; n4 < n3; ++n4) {
                        bitSetArray2[n4] = bitSetArray[n4];
                        nArray2[n4] = nArray3[n4];
                    }
                    for (n4 = n3; n4 < i - 1; ++n4) {
                        bitSetArray2[n4 + 1] = bitSetArray[n4];
                        nArray2[n4 + 1] = nArray3[n4];
                    }
                    bitSetArray2[n3] = bitSet;
                    nArray2[n3] = Integer.MIN_VALUE;
                    constraint = new Constraint(this.projection, bitSetArray2, nArray2);
                    this.evaluate(constraint);
                }
                nArray3 = cartesianProductIterator.next();
            }
        }
    }

    public boolean filter(int[] nArray) {
        return this.filter.apply(this.projection, nArray);
    }

    public boolean evaluate2(Constraint constraint) {
        double d = (double)constraint.evaluateCorpus() / (double)Maxent.corpus.size;
        double[] dArray = null;
        double d2 = 0.0;
        if (this.maxGramSize > 2) {
            int n = constraint.classIndex[0];
            int n2 = constraint.classIndex[1];
            if (this.evaluatorIsGainBased) {
                dArray = constraint.sampleViolationProbDistrib();
                d2 = ((LikelihoodAndEnergyBasedConstraintEvaluator)this.evaluator).apply(constraint, dArray, 0.0);
            } else {
                d2 = Double.MAX_VALUE;
            }
            this.valueBoundCache2[n][n2] = d2;
            this.observedPerFormCache2[n][n2] = d;
        }
        this.evaluate(constraint, dArray, d);
        return true;
    }

    public double evaluate(Constraint constraint) {
        return this.evaluate(constraint, null, -1.0);
    }

    public double evaluate(Constraint constraint, double[] dArray, double d) {
        double d2;
        if (Maxent.model.constraintSet.contains(constraint)) {
            return 0.0;
        }
        double d3 = d >= 0.0 ? d : (double)constraint.evaluateCorpus() / (double)Maxent.corpus.size;
        if (d3 > (d2 = (double)constraint.evaluateSample() / (double)Maxent.sample.size)) {
            return 0.0;
        }
        double d4 = 0.0;
        double[] dArray2 = null;
        if (this.evaluatorIsGainBased) {
            dArray2 = dArray == null ? constraint.sampleViolationProbDistrib() : dArray;
            d4 = ((LikelihoodAndEnergyBasedConstraintEvaluator)this.evaluator).apply(constraint, dArray2, d3);
        } else {
            d4 = this.evaluator.apply(constraint, d3, d2);
        }
        if (this.verbosity > 9) {
            System.out.println(constraint + "\t" + d4);
        }
        if (this.evaluator.compare(d4, this.bestValue) == -1.0) {
            this.bestValue = d4;
            this.bestConstraint = constraint.copy();
            this.numberOfEvaluationsToBest = this.numberOfEvaluations;
            double d5 = d3 * (double)Maxent.corpus.size * Maxent.scale;
            double d6 = d2 * (double)Maxent.corpus.size * Maxent.scale;
            System.out.println();
            System.out.println("new best value: " + this.bestValue + "\t" + this.bestConstraint);
            System.out.println("\tO=" + d5 + ", E=" + d6 + "\t(E-O)=" + (d6 - d5));
            System.out.println("\tp_emp=" + d3);
            System.out.println("\tg=" + Arrays.toString(dArray2));
        }
        return d4;
    }
}

