/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.DagBestPath;
import edu.ucla.fsm.ExpectationSemiring;
import edu.ucla.fsm.ExpectationSemiringWeight;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FSMQuick;
import edu.ucla.fsm.LexicographicSemiring;
import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.SparseLexicographicWeight;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AcyclicBestPathMaxent2 {
    static final double MAX_VALUE = Double.MAX_VALUE;
    static SparseLexicographicWeight[] violationVectors = null;
    static double[] p = null;
    static double[] neglogp = null;
    static double[] gammaSum = null;
    static double[] alpha = null;
    static double[] beta = null;
    static double[] expectations = null;
    static int[] topologicalOrder = null;
    static int numberOfStates = 0;
    static int numberOfConstraints = 0;
    static double[] exp_lambda = null;
    static ExpectationSemiringWeight expectationSemiringValue = new ExpectationSemiringWeight(0.0, new double[0]);
    static RealWeight logSemiringValue = new RealWeight(0.0);
    static int verbosity = 0;

    public static final void init(FSMQuick fSMQuick, int n) {
        topologicalOrder = fSMQuick.topologicalOrder;
        numberOfStates = topologicalOrder.length;
        numberOfConstraints = n;
        alpha = new double[numberOfStates];
        beta = new double[numberOfStates];
        exp_lambda = new double[numberOfConstraints];
        expectations = new double[numberOfConstraints];
        if (verbosity > 0) {
            System.out.println(fSMQuick);
            System.out.println(Arrays.toString(topologicalOrder));
        }
        HashMap<SparseLexicographicWeight, Integer> hashMap = new HashMap<SparseLexicographicWeight, Integer>();
        int n2 = 0;
        for (int n3 : topologicalOrder) {
            if (fSMQuick.transitions[n3] == null) continue;
            for (Transition transition : fSMQuick.transitions[n3]) {
                if (!hashMap.containsKey((SparseLexicographicWeight)transition.weight)) {
                    hashMap.put((SparseLexicographicWeight)transition.weight, n2);
                    ++n2;
                }
                transition.id = (Integer)hashMap.get((SparseLexicographicWeight)transition.weight);
            }
        }
        int n4 = hashMap.keySet().size();
        System.out.println("\tnumber of unique violation vectors = " + n4);
        violationVectors = new SparseLexicographicWeight[n4];
        for (Map.Entry entry : hashMap.entrySet()) {
            AcyclicBestPathMaxent2.violationVectors[((Integer)entry.getValue()).intValue()] = (SparseLexicographicWeight)entry.getKey();
        }
        p = new double[n4];
        neglogp = new double[n4];
        gammaSum = new double[n4];
    }

    public static final Object applyExpectationSemiring(FSMQuick fSMQuick, double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = numberOfConstraints - 1; n4 >= 0; --n4) {
            AcyclicBestPathMaxent2.exp_lambda[n4] = Math.exp(-dArray[n4]);
        }
        for (n4 = violationVectors.length - 1; n4 >= 0; --n4) {
            AcyclicBestPathMaxent2.p[n4] = AcyclicBestPathMaxent2.setProb(violationVectors[n4], exp_lambda);
        }
        Arrays.fill(beta, 0.0);
        n4 = topologicalOrder[numberOfStates - 1];
        AcyclicBestPathMaxent2.beta[n4] = 1.0;
        for (n3 = numberOfStates - 1; n3 >= 0; --n3) {
            n2 = topologicalOrder[n3];
            if (fSMQuick.transitions[n2] == null) continue;
            Transition[] transitionArray = fSMQuick.transitions[n2];
            int n5 = transitionArray.length;
            for (n = 0; n < n5; ++n) {
                Transition transition = transitionArray[n];
                int n6 = transition.src;
                beta[n6] = beta[n6] + p[transition.id] * beta[transition.dest];
            }
        }
        if (verbosity > 5) {
            System.out.println("beta = " + Arrays.toString(beta));
        }
        Arrays.fill(alpha, 0.0);
        Arrays.fill(gammaSum, 0.0);
        n3 = topologicalOrder[0];
        AcyclicBestPathMaxent2.alpha[n3] = 1.0;
        for (n2 = 0; n2 < numberOfStates; ++n2) {
            int n7 = topologicalOrder[n2];
            if (fSMQuick.transitions[n7] == null) continue;
            Transition[] transitionArray = fSMQuick.transitions[n7];
            n = transitionArray.length;
            for (int i = 0; i < n; ++i) {
                Transition transition = transitionArray[i];
                double d = alpha[transition.src] * p[transition.id];
                int n8 = transition.dest;
                alpha[n8] = alpha[n8] + d;
                int n9 = transition.id;
                gammaSum[n9] = gammaSum[n9] + d * beta[transition.dest];
            }
        }
        if (verbosity > 5) {
            System.out.println("alpha: " + Arrays.toString(alpha));
        }
        Arrays.fill(expectations, 0.0);
        SparseLexicographicWeight sparseLexicographicWeight = null;
        for (int i = violationVectors.length - 1; i >= 0; --i) {
            sparseLexicographicWeight = violationVectors[i];
            for (int j = sparseLexicographicWeight.len - 1; j >= 0; --j) {
                int n10 = n = sparseLexicographicWeight.indxs[j];
                expectations[n10] = expectations[n10] + gammaSum[i] * (double)sparseLexicographicWeight.vals[j];
            }
        }
        AcyclicBestPathMaxent2.expectationSemiringValue.p = alpha[n4];
        AcyclicBestPathMaxent2.expectationSemiringValue.pv = expectations;
        return expectationSemiringValue;
    }

    public static final Object applyLogSemiring(FSMQuick fSMQuick, double[] dArray) {
        int n;
        int n2;
        for (n2 = violationVectors.length - 1; n2 >= 0; --n2) {
            AcyclicBestPathMaxent2.neglogp[n2] = AcyclicBestPathMaxent2.setNegLogProb(violationVectors[n2], dArray);
        }
        Arrays.fill(alpha, Double.MAX_VALUE);
        n2 = topologicalOrder[0];
        AcyclicBestPathMaxent2.alpha[n2] = 0.0;
        for (n = 0; n < numberOfStates; ++n) {
            int n3 = topologicalOrder[n];
            if (fSMQuick.transitions[n3] == null) continue;
            for (Transition transition : fSMQuick.transitions[n3]) {
                AcyclicBestPathMaxent2.alpha[transition.dest] = alpha[transition.dest] == Double.MAX_VALUE ? alpha[transition.src] + neglogp[transition.id] : -Math.log(Math.exp(-alpha[transition.dest]) + Math.exp(-(alpha[transition.src] + neglogp[transition.id])));
            }
        }
        if (verbosity > 5) {
            System.out.println("-log(alpha): " + Arrays.toString(alpha));
        }
        n = topologicalOrder[numberOfStates - 1];
        AcyclicBestPathMaxent2.logSemiringValue.value = alpha[n];
        return logSemiringValue;
    }

    public static final double setProb(SparseLexicographicWeight sparseLexicographicWeight, double[] dArray) {
        if (sparseLexicographicWeight.vals == null) {
            return 1.0;
        }
        double d = 1.0;
        double d2 = 0.0;
        int n = sparseLexicographicWeight.len;
        for (int i = n - 1; i >= 0; --i) {
            d2 = dArray[sparseLexicographicWeight.indxs[i]];
            int n2 = sparseLexicographicWeight.vals[i];
            if (n2 == 1) {
                d *= d2;
                continue;
            }
            if (n2 == 2) {
                d *= d2 * d2;
                continue;
            }
            if (n2 == 3) {
                d *= d2 * d2 * d2;
                continue;
            }
            for (int j = n2 - 1; j >= 0; --j) {
                d *= d2;
            }
        }
        return d;
    }

    public static final double setNegLogProb(SparseLexicographicWeight sparseLexicographicWeight, double[] dArray) {
        double d = 0.0;
        int n = sparseLexicographicWeight.len;
        for (int i = n - 1; i >= 0; --i) {
            d += dArray[sparseLexicographicWeight.indxs[i]] * (double)sparseLexicographicWeight.vals[i];
        }
        return d;
    }

    public static void main(String[] stringArray) throws Exception {
        int realWeight2;
        FSM fSM = new FSM();
        int n2 = 0;
        fSM.addInitialState(n2);
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        fSM.addFinalState(n5);
        LexicographicWeight lexicographicWeight = new LexicographicWeight(new int[]{0, 0});
        LexicographicWeight lexicographicWeight2 = new LexicographicWeight(new int[]{0, 1});
        LexicographicWeight lexicographicWeight3 = new LexicographicWeight(new int[]{1, 0});
        LexicographicWeight lexicographicWeight4 = new LexicographicWeight(new int[]{1, 1});
        fSM.addTransition(new Transition(n2, 0, -1, (Weight)lexicographicWeight, n3));
        fSM.addTransition(new Transition(n2, 1, -1, (Weight)lexicographicWeight2, n3));
        fSM.addTransition(new Transition(n3, 0, -1, (Weight)lexicographicWeight3, n4));
        fSM.addTransition(new Transition(n3, 1, -1, (Weight)lexicographicWeight4, n4));
        fSM.addTransition(new Transition(n4, 0, -1, (Weight)lexicographicWeight2, n5));
        fSM.addTransition(new Transition(n4, 1, -1, (Weight)lexicographicWeight2, n5));
        System.out.println("M:\n" + fSM);
        FSMQuick fSMQuick = new FSMQuick(fSM, (Semiring)new LexicographicSemiring(2));
        for (int realWeight2 : fSMQuick.topologicalOrder) {
            if (fSMQuick.transitions[realWeight2] == null) continue;
            for (Transition transition : fSMQuick.transitions[realWeight2]) {
                transition.weight = new SparseLexicographicWeight((LexicographicWeight)transition.weight);
            }
        }
        System.out.println("Mquick:\n" + fSMQuick);
        AcyclicBestPathMaxent2.init(fSMQuick, 2);
        double[] dArray = new double[]{1.5, 2.5};
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)AcyclicBestPathMaxent2.applyExpectationSemiring(fSMQuick, dArray);
        System.out.println(expectationSemiringWeight);
        double[] dArray2 = expectationSemiringWeight.pv;
        realWeight2 = 0;
        while (realWeight2 < dArray2.length) {
            int n = realWeight2++;
            dArray2[n] = dArray2[n] / expectationSemiringWeight.p;
        }
        System.out.println(Arrays.toString(dArray2));
        RealWeight realWeight3 = (RealWeight)AcyclicBestPathMaxent2.applyLogSemiring(fSMQuick, dArray);
        System.out.println(Math.exp(-realWeight3.value));
        TIntObjectIterator tIntObjectIterator = fSM.transitions.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.weight = new ExpectationSemiringWeight(dArray, ((LexicographicWeight)transition.weight).value);
            }
        }
        System.out.println(DagBestPath.apply((FSM)fSM, (Semiring)new ExpectationSemiring(2)));
    }
}

