/*
 * Decompiled with CFR 0.152.
 */
package com.infomata.data;

import com.infomata.data.CSVFormat;
import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DataFile {
    private static final int READER = 33;
    private static final int WRITER = 18;
    private int type = 33;
    private File file = null;
    private String enc = null;
    private DataRow row = null;
    private Vector rows = null;
    private boolean first = true;
    private NumberFormat nf = null;
    private Hashtable headerIndex = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private DataFormat format = new CSVFormat();
    private boolean append = false;

    private DataFile(String enc, int type) {
        this.nf = NumberFormat.getInstance();
        this.enc = enc;
        this.type = type;
    }

    public static final DataFile createReader(String enc) {
        DataFile data = new DataFile(enc, 33);
        return data;
    }

    public static final DataFile createWriter(String enc, boolean append) {
        DataFile data = new DataFile(enc, 18);
        data.append = append;
        return data;
    }

    public final void containsHeader(boolean header) {
        this.headerIndex = header ? new Hashtable() : null;
    }

    public final boolean containsHeader() {
        return this.headerIndex != null;
    }

    public final void setDataFormat(DataFormat format) {
        this.format = format;
    }

    public void finalize() {
        this.close();
    }

    public final void close() {
        try {
            switch (this.type) {
                case 33: {
                    if (this.in != null) {
                        this.in.close();
                    }
                    if (this.headerIndex == null) break;
                    this.headerIndex.clear();
                    break;
                }
                case 18: {
                    if (this.out == null) break;
                    if (this.row != null && this.row.size() > 0) {
                        this.out.println(this.format.format(this.row));
                    }
                    this.out.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void open(File file) throws IOException {
        if (!file.exists()) {
            if (this.type == 33) {
                throw new IOException("No such file: " + file.getAbsolutePath());
            }
            if (this.type == 18 && !file.createNewFile()) {
                throw new IOException("Can't create file: " + file.getAbsolutePath());
            }
        }
        if (this.in != null || this.out != null) {
            this.close();
        }
        switch (this.type) {
            case 33: {
                if (this.enc != null && this.enc.length() > 0) {
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, this.enc);
                    this.in = new BufferedReader(isr);
                } else {
                    FileReader fr = new FileReader(file);
                    this.in = new BufferedReader(fr);
                }
                this.first = true;
                break;
            }
            case 18: {
                if (this.enc != null) {
                    FileOutputStream fos = new FileOutputStream(file.getAbsolutePath(), this.append);
                    OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, this.enc);
                    this.out = new PrintWriter(ow);
                    break;
                }
                FileWriter fw = new FileWriter(file.getAbsolutePath(), this.append);
                this.out = new PrintWriter(new BufferedWriter(fw));
                break;
            }
        }
    }

    public final DataRow next() throws IOException {
        switch (this.type) {
            case 33: {
                String line = this.in.readLine();
                if (line != null) {
                    this.row = this.format.parseLine(line);
                    if (this.row == null) {
                        this.row = this.next();
                    }
                    if (this.headerIndex == null) break;
                    if (this.first) {
                        this.first = false;
                        for (int i = 0; i < this.row.size(); ++i) {
                            this.headerIndex.put(this.row.getString(i), new Integer(i));
                        }
                        this.row = this.next();
                    }
                    this.row.setHeaderIndex(this.headerIndex);
                    break;
                }
                this.row = null;
                break;
            }
            case 18: {
                if (this.row != null) {
                    if (this.row.size() == 0) {
                        this.out.println("");
                    } else {
                        this.out.println(this.format.format(this.row));
                    }
                }
                this.row = new DataRow(this.nf);
            }
        }
        return this.row;
    }

    public final Iterator getHeaderNames() {
        ArrayList tmp = this.headerIndex == null ? new ArrayList() : new ArrayList(this.headerIndex.keySet());
        return tmp.iterator();
    }
}

