/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.GenericBestPath;
import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.LogSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionIterator;
import edu.ucla.fsm.Weight;
import gnu.trove.TIntObjectHashMap;

public class WeightPush {
    static StateIterator stateiter = new StateIterator();
    static TransitionIterator transiter = new TransitionIterator();

    public static FSM apply(FSM fSM, Semiring semiring, double d) {
        fSM.reverse();
        GenericBestPath.apply(fSM, semiring, d);
        fSM.reverse();
        TIntObjectHashMap<Weight> tIntObjectHashMap = GenericBestPath.d;
        Transition transition = null;
        stateiter.init(fSM.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM.transitions, stateiter.next());
            while (transiter.hasNext()) {
                transition = transiter.next();
                transition.weight = semiring.odiv(semiring.otimes(transition.weight, (Weight)tIntObjectHashMap.get(transition.dest)), (Weight)tIntObjectHashMap.get(transition.src));
            }
        }
        return fSM;
    }

    public static void main(String[] stringArray) throws Exception {
        FSM fSM = new FSM();
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        fSM.addInitialState(n);
        fSM.addFinalState(n4);
        fSM.addTransition(new Transition(n, 0, new LexicographicWeight(new int[]{1, 0, 0}), n2));
        fSM.addTransition(new Transition(n, 0, new LexicographicWeight(new int[]{1, 1, 0}), n3));
        fSM.addTransition(new Transition(n2, 1, new LexicographicWeight(new int[]{1, 1, 0}), n3));
        fSM.addTransition(new Transition(n3, 2, new LexicographicWeight(new int[]{1, 0, 1}), n2));
        fSM.addTransition(new Transition(n2, 0, new LexicographicWeight(new int[]{1, 1, 1}), n4));
        fSM.addTransition(new Transition(n3, 0, new LexicographicWeight(new int[]{1, 0, 0}), n4));
        System.out.println(fSM);
        double[] dArray = new double[]{0.5, 1.0, 1.5};
        System.out.println(fSM);
        WeightPush.apply(fSM, new LogSemiring(), 1.0E-15);
        System.out.println(fSM);
        Transition transition = null;
        stateiter.init(fSM.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM.transitions, stateiter.next());
            while (transiter.hasNext()) {
                transition = transiter.next();
                RealWeight realWeight = (RealWeight)transition.weight;
                transition.weight = new RealWeight(Math.exp(-realWeight.doubleValue()));
            }
        }
        System.out.println(fSM);
    }
}

