/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;

public class TropicalSemiring
extends Semiring {
    public RealWeight ZERO = new RealWeight(Double.POSITIVE_INFINITY);
    public RealWeight ONE = new RealWeight(0.0);

    @Override
    public Weight otimes(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight == null && realWeight2 != null) {
            return realWeight2;
        }
        if (realWeight != null && realWeight2 == null) {
            return realWeight;
        }
        return new RealWeight(realWeight.doubleValue() + realWeight2.doubleValue());
    }

    @Override
    public Weight oplus(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight == null && realWeight2 != null) {
            return realWeight2;
        }
        if (realWeight != null && realWeight2 == null) {
            return realWeight;
        }
        return new RealWeight(Math.min(realWeight.doubleValue(), realWeight2.doubleValue()));
    }

    @Override
    public int cmp(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        return realWeight.compareTo(realWeight2);
    }

    @Override
    public double delta(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        return Math.abs(Math.exp(-realWeight.doubleValue()) - Math.exp(-realWeight2.doubleValue()));
    }

    @Override
    public Weight getOne() {
        return this.ONE;
    }

    @Override
    public Weight getZero() {
        return this.ZERO;
    }
}

