/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Transition;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class TransitionIterator {
    Iterator<Transition> it = null;

    public void init(TIntObjectHashMap<ArrayList<Transition>> tIntObjectHashMap, int n) {
        ArrayList arrayList = (ArrayList)tIntObjectHashMap.get(n);
        this.it = arrayList == null ? null : arrayList.iterator();
    }

    public void init(TIntObjectHashMap<ArrayList<Transition>> tIntObjectHashMap, int n, Transition transition, Comparator comparator) {
        ArrayList arrayList = (ArrayList)tIntObjectHashMap.get(n);
        if (arrayList == null) {
            this.it = null;
            return;
        }
        int n2 = Collections.binarySearch(arrayList, transition, comparator);
        if (n2 < 0) {
            this.it = null;
            return;
        }
        int n3 = n2;
        while (n3 > 0) {
            if (comparator.compare(transition, arrayList.get(--n3)) == 0) continue;
            ++n3;
            break;
        }
        int n4 = n2;
        int n5 = arrayList.size() - 1;
        while (n4 < n5) {
            if (comparator.compare(transition, arrayList.get(++n4)) == 0) continue;
            --n4;
            break;
        }
        this.it = arrayList.subList(n3, n4 + 1).iterator();
    }

    public boolean hasNext() {
        if (this.it == null) {
            return false;
        }
        return this.it.hasNext();
    }

    public Transition next() {
        return this.it.next();
    }
}

