/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Weight;

public class Transition {
    public int src = 0;
    public int dest = 0;
    public int input = 0;
    public int output = 0;
    public Weight weight = null;
    public Weight baseWeight;
    public int multiplier = 0;
    public int id = 0;

    Transition() {
    }

    public Transition(int n, int n2, int n3, Weight weight, int n4) {
        this.src = n;
        this.input = n2;
        this.output = n3;
        this.weight = weight;
        this.dest = n4;
    }

    public Transition(int n, int n2, Weight weight, int n3) {
        this.src = n;
        this.input = n2;
        this.output = -1;
        this.weight = weight;
        this.dest = n3;
    }

    public Transition(int n, int n2) {
        this.src = n;
        this.dest = n2;
        this.input = -1;
        this.output = -1;
        this.weight = null;
    }

    public int hashCode() {
        int n = 7;
        n += 31 * this.src;
        n += 31 * (this.input + 1);
        n += 31 * (this.output + 1);
        return n += 31 * this.dest;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Transition)) {
            return false;
        }
        Transition transition = (Transition)object;
        if (this.src != transition.src) {
            return false;
        }
        if (this.input != transition.input) {
            return false;
        }
        if (this.output != transition.output) {
            return false;
        }
        if (this.weight != null && !this.weight.equals(transition.weight)) {
            return false;
        }
        return transition.weight == null || transition.weight.equals(this.weight);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.src);
        stringBuffer.append(" -> ");
        stringBuffer.append(this.dest);
        stringBuffer.append(" [label=\"");
        stringBuffer.append(this.input);
        stringBuffer.append(" : ");
        stringBuffer.append(this.output);
        if (this.weight != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.weight.toString());
        }
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        Transition transition = new Transition(0, 0, 0, null, 0);
        System.out.println(transition);
    }
}

