/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import gnu.trove.TIntObjectHashMap;
import java.util.TreeSet;

public class State
implements Comparable {
    public static TIntObjectHashMap<State> statePool = new TIntObjectHashMap();
    int id = 0;
    State left = null;
    State right = null;
    int hashCode = -1;

    public State(int n) {
        this.id = n;
        this.left = null;
        this.right = null;
    }

    public State(State state, State state2) {
        this.id = 0;
        this.left = state;
        this.right = state2;
    }

    public int id() {
        return this.id;
    }

    public State copy(State state) {
        State state2 = new State(state.left, state.right);
        return state2;
    }

    public int compareTo(Object object) {
        int n;
        State state = (State)object;
        if (this.id != state.id) {
            return this.id < state.id ? -1 : 1;
        }
        if (this.left != state.left) {
            if (this.left == null) {
                return -1;
            }
            if (state.left == null) {
                return 1;
            }
            n = this.left.compareTo(state.left);
            if (n != 0) {
                return n;
            }
        }
        if (this.right != state.right) {
            if (this.right == null) {
                return -1;
            }
            if (state.right == null) {
                return 1;
            }
            n = this.right.compareTo(state.right);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.id;
        if (this.left != null) {
            this.hashCode += 7 * this.left.hashCode();
        }
        if (this.right != null) {
            this.hashCode += 9 * this.right.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        State state = (State)object;
        return this.compareTo(state) == 0;
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.left == null && this.right == null) {
            stringBuilder.append(this.id);
            return stringBuilder.toString();
        }
        if (bl) {
            stringBuilder.append("\"");
        }
        stringBuilder.append("(");
        if (this.left != null) {
            stringBuilder.append(this.left.toString(false));
        }
        if (this.left != null && this.right != null) {
            stringBuilder.append(",");
        }
        if (this.right != null) {
            stringBuilder.append(this.right.toString(false));
        }
        stringBuilder.append(")");
        if (bl) {
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public static State getState(int n) {
        State state = (State)statePool.get(n);
        if (state == null) {
            state = new State(n);
            statePool.put(n, (Object)state);
        }
        return state;
    }

    public static void main(String[] stringArray) throws Exception {
        State state = new State(new State(1), new State(2));
        State state2 = new State(new State(1), new State(2));
        State state3 = new State(new State(1), new State(1));
        State state4 = new State(new State(4), new State(2));
        System.out.println("q1 compareTo q1: " + state.compareTo(state));
        System.out.println("q1 compareTo q2: " + state.compareTo(state2));
        System.out.println("q1 compareTo q3: " + state.compareTo(state3));
        System.out.println("q1 compareTo q4: " + state.compareTo(state4));
        TreeSet<State> treeSet = new TreeSet<State>();
        treeSet.add(state);
        treeSet.add(state2);
        treeSet.add(state3);
        treeSet.add(state4);
        System.out.println("Q = " + treeSet);
    }
}

