/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.Weight;
import java.util.Arrays;

public class SparseLexicographicWeight
extends Weight {
    public int[][] value = null;
    public int[] indxs = null;
    public int[] vals = null;
    public int len = 0;

    public SparseLexicographicWeight() {
        this.value = null;
        this.indxs = null;
        this.vals = null;
    }

    public SparseLexicographicWeight(int[] nArray, int[] nArray2, int n) {
        this.len = n;
        this.indxs = new int[this.len];
        System.arraycopy(nArray, 0, this.indxs, 0, this.len);
        this.vals = new int[this.len];
        System.arraycopy(nArray2, 0, this.vals, 0, this.len);
    }

    public SparseLexicographicWeight(LexicographicWeight lexicographicWeight) {
        int n;
        if (lexicographicWeight == null) {
            return;
        }
        int[] nArray = lexicographicWeight.value;
        int n2 = nArray.length;
        this.len = 0;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] == 0) continue;
            ++this.len;
        }
        this.value = null;
        this.indxs = new int[this.len];
        this.vals = new int[this.len];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == 0) continue;
            this.indxs[n] = i;
            this.vals[n] = nArray[i];
            ++n;
        }
    }

    @Override
    public int compareTo(Object object) {
        SparseLexicographicWeight sparseLexicographicWeight = (SparseLexicographicWeight)object;
        if (this.len < sparseLexicographicWeight.len) {
            return -1;
        }
        if (this.len > sparseLexicographicWeight.len) {
            return 1;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.indxs[i] < sparseLexicographicWeight.indxs[i]) {
                return -1;
            }
            if (this.indxs[i] > sparseLexicographicWeight.indxs[i]) {
                return 1;
            }
            if (this.vals[i] < sparseLexicographicWeight.vals[i]) {
                return -1;
            }
            if (this.vals[i] <= sparseLexicographicWeight.vals[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof SparseLexicographicWeight)) {
            return false;
        }
        SparseLexicographicWeight sparseLexicographicWeight = (SparseLexicographicWeight)object;
        int n = sparseLexicographicWeight.len;
        if (n != this.len) {
            return false;
        }
        return Arrays.equals(sparseLexicographicWeight.indxs, this.indxs) && Arrays.equals(sparseLexicographicWeight.vals, this.vals);
    }

    @Override
    public int hashCode() {
        int n = 7;
        for (int i = 0; i < this.len; ++i) {
            n += 31 * this.indxs[i] * this.vals[i];
        }
        return n;
    }

    @Override
    public Weight copy() {
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.indxs != null) {
            nArray = new int[this.len];
            System.arraycopy(this.indxs, 0, nArray, 0, this.len);
        }
        if (this.vals != null) {
            nArray2 = new int[this.len];
            System.arraycopy(this.vals, 0, nArray2, 0, this.len);
        }
        return new SparseLexicographicWeight(nArray, nArray2, this.len);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.len; ++i) {
            stringBuffer.append("<");
            stringBuffer.append(this.indxs[i]);
            stringBuffer.append(",");
            stringBuffer.append(this.vals[i]);
            stringBuffer.append(">");
            if (i >= this.len - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

