/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Weight;
import java.util.Arrays;

public class SparseExpectationSemiringWeight
extends Weight {
    public static final double MIN_VALUE = Double.MIN_VALUE;
    public int len = 0;
    public double p = 0.0;
    public int[] indxs = null;
    public double[] pv = null;

    public SparseExpectationSemiringWeight(double d, int n) {
        this.len = 0;
        this.p = d;
        this.indxs = new int[n];
        this.pv = new double[n];
    }

    public SparseExpectationSemiringWeight(double d, int[] nArray, double[] dArray, int n) {
        this.len = n;
        this.p = d;
        this.indxs = nArray;
        this.pv = dArray;
    }

    @Override
    public int hashCode() {
        return 7 * (int)this.p + 31 * Arrays.hashCode(this.indxs) + 31 * Arrays.hashCode(this.pv);
    }

    @Override
    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof SparseExpectationSemiringWeight)) {
            return false;
        }
        SparseExpectationSemiringWeight sparseExpectationSemiringWeight = (SparseExpectationSemiringWeight)object;
        if (this.p != sparseExpectationSemiringWeight.p) {
            return false;
        }
        return Arrays.equals(sparseExpectationSemiringWeight.indxs, this.indxs) && Arrays.equals(sparseExpectationSemiringWeight.pv, this.pv);
    }

    @Override
    public Weight copy() {
        System.out.println("*** copy() of Weight class not implemented");
        System.exit(1);
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.p);
        stringBuffer.append(",[");
        for (int i = 0; i < this.len && this.indxs[i] != -1; ++i) {
            stringBuffer.append("<");
            stringBuffer.append(this.indxs[i]);
            stringBuffer.append(",");
            stringBuffer.append(this.pv[i]);
            stringBuffer.append(">");
            if (i >= this.len - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }
}

