/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Segment;
import edu.ucla.fsm.SegmentFileReader;
import edu.ucla.fsm.StringLabel;
import java.io.File;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Sigma {
    public static Option[] OPTIONS = new Option[]{new Option("dir", true, "directory"), new Option("sym", true, "symbol table")};
    public static LinkedList<Segment> segments = null;
    public static String[] features = null;
    public static int numberOfFeatures = 0;
    public static int verbosity = 10;

    public Sigma(String[] stringArray, LinkedList<Segment> linkedList) {
        features = stringArray;
        numberOfFeatures = features.length;
        segments = linkedList;
    }

    public Sigma(String[] stringArray) {
        features = null;
        numberOfFeatures = 0;
        segments = new LinkedList();
        for (String string : stringArray) {
            segments.add(new Segment(string, null));
        }
    }

    public Sigma(CommandLine commandLine) {
        String string = commandLine.getOptionValue("dir", ".");
        String string2 = string + "/" + commandLine.getOptionValue("sym", "sym");
        try {
            SegmentFileReader.read(new File(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int indexOf(StringLabel stringLabel) {
        if (stringLabel.isEpsilon()) {
            return 0;
        }
        Segment segment = null;
        for (int i = 0; i < segments.size(); ++i) {
            segment = segments.get(i);
            if (!segment.segment.equals(stringLabel)) continue;
            return i + 1;
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        Options options = new Options();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        for (Option option : OPTIONS) {
            options.addOption(option);
        }
        commandLine = gnuParser.parse(options, stringArray, false);
        Sigma sigma = new Sigma(commandLine);
        if (verbosity > 5) {
            System.out.println(segments);
        }
    }
}

