/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.Projection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.mutable.MutableInt;

public class SequenceIndexerGold {
    static int MAXIMUM_VIOLATIONS = 50;
    Projection projection = null;
    Corpus corpus = null;
    Node rtNode = null;
    Node[] nodes = new Node[4];
    int[] counts = null;
    int[] countHist = null;
    double[] countProbDistrib = null;
    ArrayList<Node> Q = new ArrayList();
    ArrayList<Node> Qold = new ArrayList();
    ArrayList<Node> Qtmp = new ArrayList();

    public SequenceIndexerGold(Projection projection, Corpus corpus) {
        this.projection = projection;
        this.corpus = corpus;
        this.rtNode = new Node(null, -1);
        this.counts = new int[this.corpus.data_size];
        this.countHist = new int[MAXIMUM_VIOLATIONS];
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[3];
        int[] nArray5 = new int[4];
        for (int i = this.corpus.data_size - 1; i >= 0; --i) {
            nArray = this.corpus.data_key[i];
            n = this.corpus.data_freq[i];
            n2 = nArray.length;
            for (int j = 0; j < n2; ++j) {
                nArray2[0] = nArray[j];
                this.update(this.rtNode, nArray2, i, n);
                if (j == n2 - 1) continue;
                nArray3[0] = nArray[j];
                nArray3[1] = nArray[j + 1];
                this.update(this.rtNode, nArray3, i, n);
                if (j == n2 - 2) continue;
                nArray4[0] = nArray[j];
                nArray4[1] = nArray[j + 1];
                nArray4[2] = nArray[j + 2];
                this.update(this.rtNode, nArray4, i, n);
                if (j == n2 - 3 || this.projection.maxGramSize <= 3) continue;
                nArray5[0] = nArray[j];
                nArray5[1] = nArray[j + 1];
                nArray5[2] = nArray[j + 2];
                nArray5[3] = nArray[j + 3];
                this.update(this.rtNode, nArray5, i, n);
            }
        }
        this.compile();
    }

    public void update(Node node, int[] nArray, int n, int n2) {
        Node node2 = node;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!node2.descendents.containsKey(nArray[i])) {
                node2.descendents.put(nArray[i], new Node(node2, nArray[i]));
            }
            node2 = node2.descendents.get(nArray[i]);
        }
        if (node2.counts.containsKey(n)) {
            node2.counts.get(n).add(1);
        } else {
            node2.counts.put(n, new MutableInt(1));
        }
        node2.count += n2;
    }

    public void compile() {
        this.compile(this.rtNode);
    }

    public void compile(Node node) {
        node.compile();
        for (Integer n : node.descendents.keySet()) {
            this.compile(node.descendents.get(n));
        }
    }

    public int getCount(int[] nArray) {
        int n = nArray.length;
        if (n > 4) {
            System.out.println("Error: SequenceIndexer.getCount() not implemented for constraints of length > 4");
            System.exit(1);
        }
        int[][] nArray2 = this.projection.alphabet.naturalClassSegments;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int[] nArray5 = new int[1];
        int[] nArray6 = null;
        int[] nArray7 = new int[1];
        int[] nArray8 = null;
        int[] nArray9 = new int[1];
        int n2 = 0;
        for (int n3 : nArray3 = nArray2[nArray[0]]) {
            this.nodes[0] = this.rtNode.descendents_[n3];
            if (this.nodes[0] == null) continue;
            if (n == 1) {
                n2 += this.nodes[0].count;
                continue;
            }
            if (nArray[1] >= 0) {
                nArray4 = nArray2[nArray[1]];
            } else {
                nArray5[0] = this.nodes[1 + nArray[1]].segmentId;
                nArray4 = nArray5;
            }
            for (int n4 : nArray4) {
                this.nodes[1] = this.nodes[0].descendents_[n4];
                if (this.nodes[1] == null) continue;
                if (n == 2) {
                    n2 += this.nodes[1].count;
                    continue;
                }
                if (nArray[2] >= 0) {
                    nArray6 = nArray2[nArray[2]];
                } else {
                    nArray7[0] = this.nodes[2 + nArray[2]].segmentId;
                    nArray6 = nArray7;
                }
                for (int n5 : nArray6) {
                    this.nodes[2] = this.nodes[1].descendents_[n5];
                    if (this.nodes[2] == null) continue;
                    if (n == 3) {
                        n2 += this.nodes[2].count;
                        continue;
                    }
                    if (nArray[3] >= 0) {
                        nArray8 = nArray2[nArray[3]];
                    } else {
                        nArray9[0] = this.nodes[3 + nArray[3]].segmentId;
                        nArray8 = nArray9;
                    }
                    for (int n6 : nArray8) {
                        this.nodes[3] = this.nodes[2].descendents_[n6];
                        if (this.nodes[3] == null || n != 4) continue;
                        n2 += this.nodes[3].count;
                    }
                }
            }
        }
        return n2;
    }

    public int getCountNew(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        BitSet bitSet = null;
        BitSet bitSet2 = new BitSet(this.projection.alphabet.number_of_segments);
        Node node = null;
        this.Q.add(this.rtNode);
        this.Qold.clear();
        for (int i = 0; i < n2; ++i) {
            this.Qtmp = this.Qold;
            this.Qold = this.Q;
            this.Q = this.Qtmp;
            this.Q.clear();
            bitSet = this.projection.alphabet.naturalClassSets[nArray[i]];
            for (Node node2 : this.Qold) {
                bitSet2.clear();
                bitSet2.or(bitSet);
                bitSet2.and(node2.descendentSet);
                int n3 = bitSet2.nextSetBit(0);
                while (n3 != -1) {
                    node = node2.descendents.get(n3);
                    if (i == n2 - 1) {
                        n += node.count;
                    } else {
                        this.Q.add(node);
                    }
                    n3 = bitSet2.nextSetBit(n3 + 1);
                }
            }
            if (this.Q.isEmpty()) break;
        }
        return n;
    }

    public double[] getCountProbDistrib(int[] nArray) {
        this.getCountHist(nArray);
        int n = 0;
        double d = this.corpus.total_data_freq;
        double[] dArray = new double[this.countHist.length];
        for (int i = 0; i < this.countHist.length; ++i) {
            if (this.countHist[i] == 0) continue;
            dArray[i] = (double)this.countHist[i] / d;
            n = i + 1;
        }
        this.countProbDistrib = Arrays.copyOf(dArray, n);
        return this.countProbDistrib;
    }

    public int[] getCountHist(int[] nArray) {
        int n = nArray.length;
        if (n > 4) {
            System.out.println("Error: SequenceIndexer.getCountHist() not implemented for constraints of length > 4");
            System.exit(1);
        }
        int[][] nArray2 = this.projection.alphabet.naturalClassSegments;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int[] nArray5 = new int[1];
        int[] nArray6 = null;
        int[] nArray7 = new int[1];
        int[] nArray8 = null;
        int[] nArray9 = new int[1];
        Arrays.fill(this.counts, 0);
        Arrays.fill(this.countHist, 0);
        for (int n2 : nArray3 = nArray2[nArray[0]]) {
            this.nodes[0] = this.rtNode.descendents_[n2];
            if (this.nodes[0] == null) continue;
            if (n == 1) {
                this.accumulate(this.nodes[0]);
                continue;
            }
            if (nArray[1] >= 0) {
                nArray4 = nArray2[nArray[1]];
            } else {
                nArray5[0] = this.nodes[1 + nArray[1]].segmentId;
                nArray4 = nArray5;
            }
            for (int n3 : nArray4) {
                this.nodes[1] = this.nodes[0].descendents_[n3];
                if (this.nodes[1] == null) continue;
                if (n == 2) {
                    this.accumulate(this.nodes[1]);
                    continue;
                }
                if (nArray[2] >= 0) {
                    nArray6 = nArray2[nArray[2]];
                } else {
                    nArray7[0] = this.nodes[2 + nArray[2]].segmentId;
                    nArray6 = nArray7;
                }
                for (int n4 : nArray6) {
                    this.nodes[2] = this.nodes[1].descendents_[n4];
                    if (this.nodes[2] == null) continue;
                    if (n == 3) {
                        this.accumulate(this.nodes[2]);
                        continue;
                    }
                    if (nArray[3] >= 0) {
                        nArray8 = nArray2[nArray[3]];
                    } else {
                        nArray9[0] = this.nodes[3 + nArray[3]].segmentId;
                        nArray8 = nArray9;
                    }
                    for (int n5 : nArray8) {
                        this.nodes[3] = this.nodes[2].descendents_[n5];
                        if (this.nodes[3] == null || n != 4) continue;
                        this.accumulate(this.nodes[3]);
                    }
                }
            }
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int n2 = this.corpus.data_size - 1; n2 >= 0; --n2) {
            if (this.counts[n2] <= 0) continue;
            n7 = this.counts[n2];
            n8 = this.corpus.data_freq[n2];
            int n9 = n7;
            this.countHist[n9] = this.countHist[n9] + n8;
            n6 += n8;
        }
        this.countHist[0] = this.corpus.total_data_freq - n6;
        return this.countHist;
    }

    public final void accumulate(Node node) {
        for (int i = node.counts_key.length - 1; i >= 0; --i) {
            int n = node.counts_key[i];
            this.counts[n] = this.counts[n] + node.counts_value[i];
        }
    }

    public void print() {
        this.printNode(this.rtNode, 0);
    }

    public void printNode(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println(node);
        for (Map.Entry<Integer, Node> entry : node.descendents.entrySet()) {
            this.printNode(entry.getValue(), n + 1);
        }
    }

    class Node {
        int segmentId = 0;
        int count = 0;
        Node parent = null;
        HashMap<Integer, MutableInt> counts = null;
        int[] counts_key = null;
        int[] counts_value = null;
        HashMap<Integer, Node> descendents = null;
        int nDescendents = 0;
        BitSet descendentSet = null;
        Node[] descendents_ = null;

        Node(Node node, int n) {
            this.parent = node;
            this.segmentId = n;
            this.count = 0;
            this.counts = new HashMap();
            this.descendents = new HashMap();
        }

        public void compile() {
            Set<Integer> set = this.counts.keySet();
            int n = set.size();
            this.counts_key = new int[n];
            this.counts_value = new int[n];
            int n2 = 0;
            for (Integer n3 : set) {
                this.counts_key[n2] = n3;
                this.counts_value[n2] = this.counts.get(n3).intValue();
                ++n2;
            }
            this.nDescendents = this.descendents.size();
            this.descendentSet = new BitSet(this.nDescendents);
            for (Integer n3 : this.descendents.keySet()) {
                this.descendentSet.set(n3);
            }
            this.descendents_ = new Node[SequenceIndexerGold.this.projection.alphabet.number_of_segments];
            for (Integer n3 : this.descendents.keySet()) {
                this.descendents_[n3.intValue()] = this.descendents.get(n3);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.segmentId == -1) {
                stringBuffer.append("RT");
            } else {
                stringBuffer.append(SequenceIndexerGold.this.projection.alphabet.segment_names.get(this.segmentId));
            }
            stringBuffer.append(": ");
            stringBuffer.append(this.count);
            return stringBuffer.toString();
        }
    }
}

