/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.Projection;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;

public class SequenceIndexer {
    static int MAXIMUM_LENGTH = 10;
    static int MAXIMUM_VIOLATIONS = 50;
    static String FORWARD = "FORWARD";
    static String BACKWARD = "BACKWARD";
    Projection projection = null;
    Corpus corpus = null;
    String direction = null;
    Node rtNode = null;
    Node[] nodes = new Node[4];
    int[] counts = null;
    int[] countHist = null;
    double[] countProbDistrib = null;
    BitSet following = null;

    public SequenceIndexer(Projection projection, Corpus corpus) {
        this(projection, corpus, FORWARD);
    }

    public SequenceIndexer(Projection projection, Corpus corpus, String string) {
        this.projection = projection;
        this.corpus = corpus;
        this.direction = string;
        this.rtNode = new Node(null, -1);
        this.counts = new int[corpus.data_size];
        this.countHist = new int[MAXIMUM_VIOLATIONS];
        for (int i = corpus.data_size - 1; i >= 0; --i) {
            int[] nArray = corpus.data_key[i];
            int n = corpus.data_freq[i];
            if (string == BACKWARD) {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArray2[n2 - j - 1] = nArray[j];
                }
                nArray = nArray2;
            }
            this.update1(nArray, n, i);
        }
        this.compile();
    }

    public void update1(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int n4 = 0;
        Node node = null;
        Node node2 = null;
        for (int i = 0; i < n3; ++i) {
            node = this.rtNode;
            for (int j = 0; j < n3 - i && j < MAXIMUM_LENGTH && j < this.projection.maxGramSize; ++j) {
                n4 = nArray[i + j];
                node2 = (Node)node.descendents.get(n4);
                if (node2 == null) {
                    node2 = new Node(node, n4);
                    node.descendents.put(n4, (Object)node2);
                }
                node = node2;
                node.count += n;
                if (node.counts.containsKey(n2)) {
                    ((MutableInt)node.counts.get(n2)).add(1);
                    continue;
                }
                node.counts.put(n2, (Object)new MutableInt(1));
            }
        }
    }

    public void compile() {
        Node node = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(this.rtNode);
        while (!linkedList.isEmpty()) {
            node = (Node)linkedList.removeFirst();
            node.compile();
            for (Integer n : node.descendents.keySet()) {
                linkedList.add(node.descendents.get(n));
            }
        }
    }

    public int getCount(BitSet[] bitSetArray) {
        int n = 0;
        int n2 = bitSetArray.length;
        Iterator[] iteratorArray = new Iterator[n2];
        iteratorArray[0] = this.rtNode.descendents.entrySet().iterator();
        int n3 = 0;
        Map.Entry entry = null;
        while (n3 >= 0) {
            if (n3 == n2 - 1) {
                while (iteratorArray[n3].hasNext()) {
                    entry = (Map.Entry)iteratorArray[n3].next();
                    if (!bitSetArray[n3].get((Integer)entry.getKey())) continue;
                    n += ((Node)entry.getValue()).count;
                }
                --n3;
                continue;
            }
            if (!iteratorArray[n3].hasNext()) {
                iteratorArray[n3] = null;
                --n3;
                continue;
            }
            entry = (Map.Entry)iteratorArray[n3].next();
            if (!bitSetArray[n3].get((Integer)entry.getKey())) continue;
            iteratorArray[++n3] = ((Node)entry.getValue()).descendents.entrySet().iterator();
        }
        return n;
    }

    public boolean exists(BitSet[] bitSetArray) {
        int n = bitSetArray.length;
        Iterator[] iteratorArray = new Iterator[n];
        iteratorArray[0] = this.rtNode.descendents.entrySet().iterator();
        int n2 = 0;
        Map.Entry entry = null;
        while (n2 >= 0) {
            if (n2 == n - 1) {
                while (iteratorArray[n2].hasNext()) {
                    entry = (Map.Entry)iteratorArray[n2].next();
                    if (!bitSetArray[n2].get((Integer)entry.getKey())) continue;
                    return true;
                }
                --n2;
                continue;
            }
            if (!iteratorArray[n2].hasNext()) {
                iteratorArray[n2] = null;
                --n2;
                continue;
            }
            entry = (Map.Entry)iteratorArray[n2].next();
            if (!bitSetArray[n2].get((Integer)entry.getKey())) continue;
            iteratorArray[++n2] = ((Node)entry.getValue()).descendents.entrySet().iterator();
        }
        return false;
    }

    public BitSet getFollowing(BitSet[] bitSetArray) {
        if (this.following == null) {
            this.following = new BitSet(this.projection.alphabet.number_of_segments);
        } else {
            this.following.clear();
        }
        Map.Entry entry2 = null;
        int n = bitSetArray == null ? 0 : bitSetArray.length;
        int n2 = 0;
        if (n == 0) {
            for (Map.Entry entry2 : this.rtNode.descendents.entrySet()) {
                this.following.set((Integer)entry2.getKey());
            }
            return this.following;
        }
        Iterator[] iteratorArray = new Iterator[n];
        iteratorArray[0] = this.rtNode.descendents.entrySet().iterator();
        while (n2 >= 0) {
            if (n2 == n - 1) {
                while (iteratorArray[n2].hasNext()) {
                    entry2 = (Map.Entry)iteratorArray[n2].next();
                    if (!bitSetArray[n2].get((Integer)entry2.getKey())) continue;
                    ObjectIterator objectIterator = ((Node)entry2.getValue()).descendents.entrySet().iterator();
                    while (objectIterator.hasNext()) {
                        this.following.set((Integer)((Map.Entry)objectIterator.next()).getKey());
                    }
                }
                --n2;
                continue;
            }
            if (!iteratorArray[n2].hasNext()) {
                iteratorArray[n2] = null;
                --n2;
                continue;
            }
            entry2 = (Map.Entry)iteratorArray[n2].next();
            if (!bitSetArray[n2].get((Integer)entry2.getKey())) continue;
            iteratorArray[++n2] = ((Node)entry2.getValue()).descendents.entrySet().iterator();
        }
        return this.following;
    }

    public int[] getCountHist(BitSet[] bitSetArray) {
        int n;
        Arrays.fill(this.countHist, 0);
        Arrays.fill(this.counts, 0);
        int n2 = bitSetArray.length;
        Iterator[] iteratorArray = new Iterator[n2];
        iteratorArray[0] = this.rtNode.descendents.entrySet().iterator();
        int n3 = 0;
        Map.Entry entry = null;
        Node node = null;
        while (n3 >= 0) {
            if (n3 == n2 - 1) {
                while (iteratorArray[n3].hasNext()) {
                    entry = (Map.Entry)iteratorArray[n3].next();
                    if (!bitSetArray[n3].get((Integer)entry.getKey())) continue;
                    node = (Node)entry.getValue();
                    for (n = node.counts_key.length - 1; n >= 0; --n) {
                        int n4 = node.counts_key[n];
                        this.counts[n4] = this.counts[n4] + node.counts_value[n];
                    }
                }
                --n3;
                continue;
            }
            if (!iteratorArray[n3].hasNext()) {
                iteratorArray[n3] = null;
                --n3;
                continue;
            }
            entry = (Map.Entry)iteratorArray[n3].next();
            if (!bitSetArray[n3].get((Integer)entry.getKey())) continue;
            iteratorArray[++n3] = ((Node)entry.getValue()).descendents.entrySet().iterator();
        }
        n = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = this.corpus.data_size - 1; i >= 0; --i) {
            if (this.counts[i] <= 0) continue;
            n5 = this.counts[i];
            n6 = this.corpus.data_freq[i];
            int n7 = n5;
            this.countHist[n7] = this.countHist[n7] + n6;
            n += n6;
        }
        this.countHist[0] = this.corpus.total_data_freq - n;
        return this.countHist;
    }

    public double[] getCountProbDistrib(BitSet[] bitSetArray) {
        this.getCountHist(bitSetArray);
        int n = 0;
        double d = this.corpus.total_data_freq;
        double[] dArray = new double[this.countHist.length];
        for (int i = 0; i < this.countHist.length; ++i) {
            if (this.countHist[i] == 0) continue;
            dArray[i] = (double)this.countHist[i] / d;
            n = i + 1;
        }
        this.countProbDistrib = Arrays.copyOf(dArray, n);
        return this.countProbDistrib;
    }

    public void print() {
        this.printNode(this.rtNode, 0);
    }

    public void printNode(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println(node);
        for (Map.Entry entry : node.descendents.entrySet()) {
            this.printNode((Node)entry.getValue(), n + 1);
        }
    }

    class Node {
        int segmentId = 0;
        int count = 0;
        Node parent = null;
        Int2ObjectOpenHashMap<MutableInt> counts = null;
        int[] counts_key = null;
        int[] counts_value = null;
        Int2ObjectOpenHashMap<Node> descendents = null;
        int nDescendents = 0;
        BitSet descendentSet = null;

        Node(Node node, int n) {
            this.parent = node;
            this.segmentId = n;
            this.count = 0;
            this.counts = new Int2ObjectOpenHashMap();
            this.descendents = new Int2ObjectOpenHashMap();
        }

        public void compile() {
            int n;
            IntSet intSet = this.counts.keySet();
            int n2 = intSet.size();
            this.counts_key = new int[n2];
            this.counts_value = new int[n2];
            int n3 = 0;
            Iterator iterator = intSet.iterator();
            while (iterator.hasNext()) {
                this.counts_key[n3] = n = ((Integer)iterator.next()).intValue();
                this.counts_value[n3] = ((MutableInt)this.counts.get(n)).intValue();
                ++n3;
            }
            this.descendents.trim();
            this.nDescendents = this.descendents.size();
            this.descendentSet = new BitSet(this.nDescendents);
            iterator = this.descendents.keySet().iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                this.descendentSet.set(n);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.segmentId == -1) {
                stringBuffer.append("RT");
            } else {
                stringBuffer.append(SequenceIndexer.this.projection.alphabet.segment_names.get(this.segmentId));
            }
            stringBuffer.append(": count=");
            stringBuffer.append(this.count);
            return stringBuffer.toString();
        }
    }
}

