/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;

public class RealSemiring
extends Semiring {
    public RealWeight ZERO = new RealWeight(0.0);
    public RealWeight ONE = new RealWeight(1.0);
    public static final double MIN_VALUE = Double.MIN_VALUE;

    @Override
    public Weight oplus(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight.equals(this.ZERO)) {
            return new RealWeight(realWeight2.doubleValue());
        }
        if (realWeight2.equals(this.ZERO)) {
            return new RealWeight(realWeight.doubleValue());
        }
        return new RealWeight(realWeight.doubleValue() + realWeight2.doubleValue());
    }

    @Override
    public Weight otimes(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight.equals(this.ZERO) || realWeight2.equals(this.ZERO)) {
            return this.ZERO;
        }
        if (realWeight.equals(this.ONE)) {
            return new RealWeight(realWeight2.doubleValue());
        }
        if (realWeight2.equals(this.ONE)) {
            return new RealWeight(realWeight.doubleValue());
        }
        double d = realWeight.doubleValue() * realWeight2.doubleValue();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            d = Double.MIN_VALUE;
        }
        return new RealWeight(d);
    }

    @Override
    public Weight odiv(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight2.equals(this.ZERO)) {
            System.out.println("Error: tried to divide by a weight equal to 0 in RealSemiring");
        }
        if (realWeight.equals(this.ZERO)) {
            return this.ZERO;
        }
        if (realWeight.equals(this.ONE)) {
            return new RealWeight(realWeight2.doubleValue());
        }
        if (realWeight2.equals(this.ONE)) {
            return new RealWeight(realWeight.doubleValue());
        }
        return new RealWeight(realWeight.doubleValue() / realWeight2.doubleValue());
    }

    @Override
    public int cmp(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        return realWeight.compareTo(realWeight2);
    }

    @Override
    public double delta(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        if (realWeight == null) {
            return Double.MAX_VALUE;
        }
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight2 == null) {
            return realWeight.doubleValue();
        }
        return Math.abs(realWeight.doubleValue() - realWeight2.doubleValue());
    }

    @Override
    public Weight getOne() {
        return this.ONE;
    }

    @Override
    public Weight getZero() {
        return this.ZERO;
    }
}

