/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.SequenceIndexer;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitiveReductionAcyclic;
import edu.ucla.fsm.TreeReductionAcyclic;
import edu.ucla.util.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;

public class Projection {
    public String name = null;
    public BitSet segmentMask = null;
    public boolean[] segmentMaskBoolean = null;
    public boolean oneOrMoreSegmentsMasked = false;
    public boolean isDefault = false;
    public int id = 0;
    public int maxGramSize = 0;
    public Alphabet alphabet = null;
    public Corpus corpus = null;
    public Corpus sample = null;
    public SequenceIndexer corpusIndexer = null;
    public SequenceIndexer corpusIndexerRev = null;
    public SequenceIndexer sampleIndexer = null;
    public boolean[][] naturalClassGraphAdj = null;
    public int[][] naturalClassGraphInt = null;
    public int[][] naturalClassGraphIntransInt = null;
    public FSM naturalClassTree = null;
    public int[][] naturalClassTreeAdj = null;
    public LinkedList<TreeSet<int[]>> searchSpace = null;
    public int[] projectedForm = new int[50];
    public int projectedLength = 0;
    static int projectionCounter = 0;
    static int verbosity = 0;

    public Projection(Alphabet alphabet) {
        this.name = "default";
        this.id = projectionCounter++;
        this.isDefault = true;
        this.segmentMask = null;
        this.alphabet = alphabet;
        this.makeNaturalClassGraph();
    }

    /*
     * WARNING - void declaration
     */
    public Projection(Alphabet alphabet, String[] stringArray, boolean bl, int n) {
        int n2;
        void var12_20;
        String[] stringArray2;
        int n3;
        void var11_14;
        if (verbosity > 5) {
            System.out.println("constructing projection from descriptor: " + Arrays.toString(stringArray));
        }
        this.name = stringArray[0];
        if (verbosity > 5) {
            System.out.println(this.name);
        }
        this.id = projectionCounter++;
        this.isDefault = false;
        int n4 = alphabet.number_of_segments;
        int n5 = alphabet.number_of_features;
        String[] stringArray3 = stringArray[1].replaceAll(" *", "").split(",");
        int[] nArray = new int[n5];
        String[] objectArray = stringArray3;
        int stringArray22 = objectArray.length;
        boolean object = false;
        while (var11_14 < stringArray22) {
            int n6;
            String string = objectArray[var11_14];
            n3 = alphabet.feature_names.indexOf(string.substring(1));
            int n7 = n6 = string.substring(0, 1).equals("+") ? 1 : -1;
            if (n3 == -1) {
                System.out.println("Projection constructor: did not recognize feature of " + string);
            } else {
                nArray[n3] = n6;
            }
            ++var11_14;
        }
        if (verbosity > 5) {
            System.out.println("criterial features: " + Arrays.toString(nArray));
        }
        boolean[] blArray = new boolean[n5];
        String[] stringArray4 = stringArray2 = stringArray[2].replaceAll(" *", "").split(",");
        int n8 = stringArray4.length;
        for (n3 = 0; n3 < n8; ++n3) {
            String string = stringArray4[n3];
            int n9 = alphabet.feature_names.indexOf(string);
            if (n9 == -1) {
                System.out.println("Projection constructor: did not recognize feature of " + string);
                continue;
            }
            blArray[n9] = true;
        }
        if (verbosity > 5) {
            System.out.println("projected features: " + Arrays.toString(blArray));
        }
        this.segmentMask = new BitSet(n4);
        int[][] nArray2 = new int[n4][n5];
        boolean bl2 = false;
        while (var12_20 < alphabet.number_of_segments) {
            if (var12_20 == false || Projection.subsumes(alphabet.feature_matrix[var12_20], nArray)) {
                System.arraycopy(alphabet.feature_matrix[var12_20], 0, nArray2[var12_20], 0, n5);
                for (n3 = 1; n3 < n5; ++n3) {
                    if (blArray[n3]) continue;
                    nArray2[var12_20][n3] = 0;
                }
                this.segmentMask.set((int)var12_20);
            }
            ++var12_20;
        }
        this.oneOrMoreSegmentsMasked = this.segmentMask.cardinality() > 0;
        this.segmentMaskBoolean = new boolean[n4];
        int n10 = this.segmentMask.nextSetBit(0);
        while (n2 != -1) {
            this.segmentMaskBoolean[n2] = true;
            n2 = this.segmentMask.nextSetBit((int)(n2 + true));
        }
        if (verbosity > 5) {
            System.out.println("segment mask on projection " + this.name + ": " + this.segmentMask);
        }
        this.alphabet = new Alphabet(alphabet.feature_names, alphabet.segment_names, nArray2, this.segmentMask, bl, n);
        if (verbosity > 5) {
            for (int[] nArray3 : this.alphabet.naturalClassSegments) {
                System.out.println(Arrays.toString(nArray3));
            }
            for (boolean[] blArray2 : this.alphabet.naturalClassDenotations) {
                System.out.println(Arrays.toString(blArray2));
            }
        }
        this.makeNaturalClassGraph();
    }

    static boolean subsumes(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] == 0 || nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    void makeNaturalClassGraph() {
        int n;
        int n2;
        System.out.println("Making natural class graph ...");
        boolean bl = false;
        boolean bl2 = false;
        FSM fSM = new FSM();
        for (n2 = 0; n2 < this.alphabet.moreGeneralThan.length; ++n2) {
            fSM.addInitialState(n2);
            for (int n3 : this.alphabet.moreGeneralThan[n2]) {
                if (n3 == n2) continue;
                fSM.initials.remove(n3);
                fSM.addTransition(new Transition(n2, n3));
            }
        }
        this.naturalClassGraphAdj = new boolean[this.alphabet.number_of_natural_classes][this.alphabet.number_of_natural_classes];
        this.naturalClassGraphInt = new int[this.alphabet.number_of_natural_classes][];
        for (n2 = 0; n2 < this.alphabet.naturalClassNames.length; ++n2) {
            this.naturalClassGraphAdj[n2] = new boolean[this.alphabet.number_of_natural_classes];
            this.naturalClassGraphAdj[n2][n2] = true;
            if (fSM.transitions.containsKey(n2)) {
                this.naturalClassGraphInt[n2] = new int[((ArrayList)fSM.transitions.get(n2)).size()];
                int n4 = 0;
                for (Transition transition : (ArrayList)fSM.transitions.get(n2)) {
                    this.naturalClassGraphAdj[n2][transition.dest] = true;
                    this.naturalClassGraphInt[n2][n4++] = transition.dest;
                }
                continue;
            }
            this.naturalClassGraphInt[n2] = new int[0];
        }
        if (verbosity > 5) {
            for (boolean[] blArray : this.naturalClassGraphAdj) {
                System.out.println(Arrays.toString(blArray));
            }
        }
        fSM = TransitiveReductionAcyclic.apply(fSM);
        this.naturalClassGraphIntransInt = new int[this.alphabet.number_of_natural_classes][];
        for (n = 0; n < this.alphabet.number_of_natural_classes; ++n) {
            if (!fSM.transitions.containsKey(n)) {
                this.naturalClassGraphIntransInt[n] = new int[0];
                continue;
            }
            this.naturalClassGraphIntransInt[n] = new int[((ArrayList)fSM.transitions.get(n)).size()];
            int n5 = 0;
            for (Transition transition : (ArrayList)fSM.transitions.get(n)) {
                this.naturalClassGraphIntransInt[n][n5++] = transition.dest;
            }
        }
        this.naturalClassTree = TreeReductionAcyclic.apply(fSM);
        this.naturalClassTreeAdj = new int[this.alphabet.number_of_natural_classes][];
        for (n = 0; n < this.alphabet.naturalClassNames.length; ++n) {
            if (!this.naturalClassTree.transitions.containsKey(n)) {
                this.naturalClassTreeAdj[n] = new int[0];
                continue;
            }
            this.naturalClassTreeAdj[n] = new int[((ArrayList)this.naturalClassTree.transitions.get(n)).size()];
            int n6 = 0;
            for (Transition transition : (ArrayList)this.naturalClassTree.transitions.get(n)) {
                this.naturalClassTreeAdj[n][n6++] = transition.dest;
            }
        }
        if (verbosity > 5) {
            for (int[] nArray : this.naturalClassTreeAdj) {
                System.out.println(Arrays.toString(nArray));
            }
        }
    }

    public void setCorpus(Corpus corpus) {
        if (corpus == null) {
            return;
        }
        if (this.isDefault) {
            this.corpus = corpus;
        } else {
            this.corpus = new Corpus(this.alphabet.number_of_segments, true);
            for (Map.Entry<int[], Counter> entry : corpus.data.entrySet()) {
                this.project(entry.getKey());
                this.corpus.updateCounts(this.projectedForm, 0, this.projectedLength, entry.getValue().intValue());
            }
            this.corpus.compile();
        }
        this.corpusIndexer = new SequenceIndexer(this, this.corpus);
        this.corpusIndexerRev = new SequenceIndexer(this, this.corpus, SequenceIndexer.BACKWARD);
    }

    public void setSample(Corpus corpus) {
        if (this.isDefault) {
            this.sample = corpus;
        } else {
            this.sample = new Corpus(this.alphabet.number_of_segments, true);
            for (Map.Entry<int[], Counter> entry : corpus.data.entrySet()) {
                this.project(entry.getKey());
                this.sample.updateCounts(this.projectedForm, 0, this.projectedLength, entry.getValue().intValue());
            }
            this.sample.compile();
        }
        this.sampleIndexer = new SequenceIndexer(this, this.sample);
    }

    public void printSample() {
        System.out.print("sample: ");
        for (int[] nArray : this.sample.data.keySet()) {
            System.out.println(this.alphabet.decodeString(nArray) + " (" + this.sample.data.get(nArray) + ") ");
        }
        System.out.println();
    }

    public void project(int[] nArray) {
        this.projectedLength = 0;
        for (int n : nArray) {
            if (!this.segmentMaskBoolean[n]) continue;
            this.projectedForm[this.projectedLength++] = n;
        }
        if (verbosity > 9) {
            System.out.println("projection of " + Arrays.toString(nArray) + " is " + Arrays.toString(this.projectedForm) + " (" + this.projectedLength + ")");
        }
    }

    public BitSet getSegsObservedInContext(BitSet[] bitSetArray, int n) {
        int n2;
        BitSet[] bitSetArray2 = n == 0 ? null : Arrays.copyOfRange(bitSetArray, 0, n);
        BitSet[] bitSetArray3 = n == bitSetArray.length ? null : Arrays.copyOfRange(bitSetArray, n, bitSetArray.length);
        BitSet bitSet = this.corpusIndexer.getFollowing(bitSetArray2);
        if (bitSet.isEmpty()) {
            return bitSet;
        }
        BitSet[] bitSetArray4 = null;
        if (bitSetArray3 == null || bitSetArray3.length < 2) {
            bitSetArray4 = bitSetArray3;
        } else {
            int n3 = bitSetArray3.length;
            bitSetArray4 = new BitSet[n3];
            for (int i = 0; i < n3; ++i) {
                bitSetArray4[n3 - i - 1] = bitSetArray3[i];
            }
        }
        BitSet bitSet2 = this.corpusIndexerRev.getFollowing(bitSetArray4);
        if (bitSet2.isEmpty()) {
            return bitSet2;
        }
        BitSet bitSet3 = bitSet;
        bitSet3.and(bitSet2);
        if (bitSetArray2 == null || bitSetArray2.length == 0 || bitSetArray3 == null || bitSetArray3.length == 0 || bitSet3.isEmpty()) {
            return bitSet3;
        }
        int n4 = bitSetArray2.length;
        int n5 = bitSetArray3.length;
        int n6 = n4 + n5 + 1;
        BitSet[] bitSetArray5 = new BitSet[n6];
        for (n2 = 0; n2 < n4; ++n2) {
            bitSetArray5[n2] = bitSetArray2[n2];
        }
        bitSetArray5[n] = new BitSet(this.alphabet.number_of_segments);
        for (n2 = 0; n2 < n5; ++n2) {
            bitSetArray5[n + n2 + 1] = bitSetArray3[n2];
        }
        n2 = bitSet3.nextSetBit(0);
        while (n2 != -1) {
            bitSetArray5[n].clear();
            bitSetArray5[n].set(n2);
            if (!this.corpusIndexer.exists(bitSetArray5)) {
                bitSet3.clear(n2);
            }
            n2 = bitSet3.nextSetBit(n2 + 1);
        }
        return bitSet3;
    }

    public String segmentSetToString(BitSet bitSet) {
        int n = this.classIndex(bitSet);
        if (n != -1) {
            return this.alphabet.naturalClassNames[n];
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        int n2 = bitSet.nextSetBit(0);
        while (n2 != -1) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.alphabet.segment_names.get(n2));
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public BitSet stringToSegmentSet(String string) {
        int n;
        boolean bl = string.startsWith("[");
        boolean bl2 = string.contains("^");
        String[] stringArray = string.split(",");
        BitSet bitSet = null;
        if (bl) {
            int[] nArray = new int[this.alphabet.number_of_features];
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                stringArray[i] = stringArray[i].replaceAll("]|}", "");
                stringArray[i] = stringArray[i].replaceAll("\\Q^\\E", "");
                stringArray[i] = stringArray[i].replaceAll("\\Q[\\E", "");
                stringArray[i] = stringArray[i].replaceAll("\\Q{\\E", "");
                stringArray[i] = stringArray[i].replaceAll("\\s*", "");
                if (stringArray[i].equals("")) {
                    nArray[0] = -1;
                    continue;
                }
                String string2 = stringArray[i].substring(1);
                nArray[this.alphabet.feature_names.indexOf((Object)string2)] = n2 = stringArray[i].substring(0, 1).equals("+") ? 1 : -1;
            }
            bitSet = this.featuresToSegmentSet(nArray);
        } else {
            bitSet = new BitSet(this.alphabet.number_of_segments);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].replaceAll("]|}", "");
                stringArray[i] = stringArray[i].replaceAll("\\Q^\\E", "");
                stringArray[i] = stringArray[i].replaceAll("\\Q[\\E", "");
                stringArray[i] = stringArray[i].replaceAll("\\Q{\\E", "");
                stringArray[i] = stringArray[i].replaceAll("\\s*", "");
                if (stringArray[i].equals("")) continue;
                bitSet.set(this.alphabet.segment_names.indexOf(stringArray[i]));
            }
        }
        if (bl2) {
            bitSet.flip(0, this.alphabet.number_of_segments);
            bitSet.clear(0);
        }
        if (this.segmentMask != null) {
            bitSet.and(this.segmentMask);
        }
        if ((n = this.classIndex(bitSet)) != -1) {
            bitSet = this.alphabet.naturalClassSets[n];
        }
        return bitSet;
    }

    public BitSet featuresToSegmentSet(int[] nArray) {
        BitSet bitSet = new BitSet(this.alphabet.number_of_segments);
        bitSet.set(0, this.alphabet.number_of_segments);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            for (int j = 0; j < this.alphabet.number_of_segments; ++j) {
                if (this.alphabet.feature_matrix[j][i] == nArray[i]) continue;
                bitSet.clear(j);
            }
        }
        return bitSet;
    }

    public int classIndex(BitSet bitSet) {
        int n = -1;
        for (int i = 0; i < this.alphabet.naturalClassSets.length; ++i) {
            if (!this.alphabet.naturalClassSets[i].equals(bitSet)) continue;
            n = i;
            break;
        }
        return n;
    }

    public String toString() {
        return this.name;
    }
}

