/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.CorpusReader;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FeatureMatrixReader;
import edu.ucla.fsm.IntegerWeight2;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionIterator;
import edu.ucla.util.Counter;
import java.util.Map;
import java.util.TreeMap;

public class PrefixTree {
    static TransitionIterator transiter = new TransitionIterator();
    static int id = 0;

    public static FSM apply(TreeMap<int[], Counter> treeMap) {
        FSM fSM = new FSM();
        int n = id++;
        fSM.addInitialState(n);
        for (Map.Entry<int[], Counter> entry : treeMap.entrySet()) {
            PrefixTree.apply(fSM, entry.getKey(), entry.getValue().value);
        }
        return fSM;
    }

    static void apply(FSM fSM, int[] nArray, int n) {
        Transition transition = null;
        int n2 = 0;
        block0: for (int n3 : nArray) {
            int n4;
            transiter.init(fSM.transitions, n2);
            while (transiter.hasNext()) {
                transition = transiter.next();
                if (transition.input != n3) continue;
                ((IntegerWeight2)transition.weight).add(n);
                n2 = transition.dest;
                continue block0;
            }
            ++id;
            fSM.addTransition(new Transition(n2, n3, -1, new IntegerWeight2(n), n4));
            n2 = n4;
        }
        fSM.addFinalState(n2);
    }

    public static void main(String[] stringArray) throws Exception {
        Alphabet alphabet = FeatureMatrixReader.apply(stringArray[0]);
        Corpus corpus = CorpusReader.apply(stringArray[1], alphabet, true);
        FSM fSM = PrefixTree.apply(corpus.data);
        System.out.println(fSM);
    }
}

