/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;

public class LogSemiring
extends Semiring {
    static final double posInfinity = Double.POSITIVE_INFINITY;
    static final double negInfinity = Double.NEGATIVE_INFINITY;
    public RealWeight ZERO = new RealWeight(Double.POSITIVE_INFINITY);
    public RealWeight ONE = new RealWeight(0.0);
    public static final double MIN_VALUE = Double.MIN_VALUE;

    @Override
    public Weight oplus(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight.equals(this.ZERO)) {
            return new RealWeight(realWeight2.doubleValue());
        }
        if (realWeight2.equals(this.ZERO)) {
            return new RealWeight(realWeight.doubleValue());
        }
        double d = -Math.log(Math.exp(-realWeight.doubleValue()) + Math.exp(-realWeight2.doubleValue()));
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            d = Double.MAX_VALUE;
        }
        return new RealWeight(d);
    }

    @Override
    public Weight otimes(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight.equals(this.ZERO) || realWeight2.equals(this.ZERO)) {
            return this.ZERO;
        }
        if (realWeight.equals(this.ONE)) {
            return new RealWeight(realWeight2.doubleValue());
        }
        if (realWeight2.equals(this.ONE)) {
            return new RealWeight(realWeight.doubleValue());
        }
        double d = realWeight.doubleValue() + realWeight2.doubleValue();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            d = Double.MAX_VALUE;
        }
        return new RealWeight(d);
    }

    @Override
    public Weight odiv(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        if (realWeight == null || realWeight2 == null) {
            System.out.println("Error: applied division operator to null weight in LogSemiring");
            System.exit(1);
        }
        double d = realWeight.doubleValue();
        double d2 = realWeight2.doubleValue();
        if (d2 == Double.POSITIVE_INFINITY) {
            return new RealWeight(Double.NEGATIVE_INFINITY);
        }
        if (d == Double.POSITIVE_INFINITY) {
            return this.ZERO;
        }
        return new RealWeight(d - d2);
    }

    @Override
    public double delta(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        return Math.abs(Math.exp(-realWeight.doubleValue()) - Math.exp(-realWeight2.doubleValue()));
    }

    @Override
    public int cmp(Weight weight, Weight weight2) {
        RealWeight realWeight = (RealWeight)weight;
        RealWeight realWeight2 = (RealWeight)weight2;
        return realWeight.compareTo(realWeight2);
    }

    @Override
    public Weight getOne() {
        return this.ONE;
    }

    @Override
    public Weight getZero() {
        return this.ZERO;
    }
}

