/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;

public class LexicographicSemiring
extends Semiring {
    int N = 0;
    LexicographicWeight ZERO = null;
    LexicographicWeight ONE = null;

    public LexicographicSemiring() {
    }

    public LexicographicSemiring(int n) {
        this.N = n;
        this.ZERO = null;
        this.ONE = new LexicographicWeight(new int[this.N]);
    }

    @Override
    public Weight otimes(Weight weight, Weight weight2) {
        LexicographicWeight lexicographicWeight = (LexicographicWeight)weight;
        LexicographicWeight lexicographicWeight2 = (LexicographicWeight)weight2;
        if (lexicographicWeight == this.ZERO || lexicographicWeight2 == this.ZERO) {
            return this.ZERO;
        }
        if (lexicographicWeight == this.ONE) {
            return lexicographicWeight2;
        }
        if (lexicographicWeight2 == this.ONE) {
            return lexicographicWeight;
        }
        int[] nArray = (int[])lexicographicWeight.value();
        int[] nArray2 = (int[])lexicographicWeight2.value();
        int n = nArray.length;
        int[] nArray3 = new int[n];
        for (int i = n - 1; i >= 0; --i) {
            nArray3[i] = nArray[i] + nArray2[i];
        }
        return new LexicographicWeight(nArray3);
    }

    @Override
    public Weight oplus(Weight weight, Weight weight2) {
        LexicographicWeight lexicographicWeight = (LexicographicWeight)weight;
        LexicographicWeight lexicographicWeight2 = (LexicographicWeight)weight2;
        if (lexicographicWeight == this.ZERO) {
            return lexicographicWeight2;
        }
        if (lexicographicWeight2 == this.ZERO) {
            return lexicographicWeight;
        }
        int[] nArray = (int[])lexicographicWeight.value();
        int[] nArray2 = (int[])lexicographicWeight2.value();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return nArray[i] > nArray2[i] ? weight : weight2;
        }
        return weight;
    }

    @Override
    public int cmp(Weight weight, Weight weight2) {
        LexicographicWeight lexicographicWeight = (LexicographicWeight)weight;
        LexicographicWeight lexicographicWeight2 = (LexicographicWeight)weight2;
        if (lexicographicWeight == lexicographicWeight2) {
            return 0;
        }
        if (lexicographicWeight == this.ZERO) {
            return 1;
        }
        if (lexicographicWeight2 == this.ZERO) {
            return -1;
        }
        int[] nArray = (int[])lexicographicWeight.value();
        int[] nArray2 = (int[])lexicographicWeight2.value();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] > nArray2[i]) {
                return -1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public double delta(Weight weight, Weight weight2) {
        System.out.println("LexicographicSemiring.delta() not implemented");
        System.exit(1);
        return 0.0;
    }

    @Override
    public Weight getOne() {
        return this.ONE;
    }

    @Override
    public Weight getZero() {
        return this.ZERO;
    }
}

