/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.BrzozowskiMinimization;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionIterator;
import edu.ucla.util.Node;
import edu.ucla.util.RegexpParser;
import edu.ucla.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class HopcroftUllmanConstruction {
    static StateIterator stateiter = new StateIterator();
    static StateIterator stateiter2 = new StateIterator();
    static StateIterator stateiter3 = new StateIterator();
    static TransitionIterator transiter = new TransitionIterator();

    public static FSM apply(String string) {
        Scanner scanner = new Scanner(string);
        RegexpParser regexpParser = new RegexpParser(scanner);
        FSM fSM = HopcroftUllmanConstruction.apply(regexpParser.parse());
        if (fSM != null) {
            fSM.renameStates();
        }
        return fSM;
    }

    public static FSM apply(Node node) {
        FSM fSM = HopcroftUllmanConstruction.build(node);
        if (fSM != null) {
            fSM.renameStates();
        }
        return fSM;
    }

    public static FSM build(Node node) {
        FSM fSM = null;
        if (node.type == Node.Type.SEGMENT) {
            fSM = HopcroftUllmanConstruction.buildSeg(node);
        } else if (node.type == Node.Type.DOT) {
            fSM = HopcroftUllmanConstruction.buildDot(HopcroftUllmanConstruction.build(node.left), HopcroftUllmanConstruction.build(node.right));
        } else if (node.type == Node.Type.PIPE) {
            fSM = HopcroftUllmanConstruction.buildPipe(HopcroftUllmanConstruction.build(node.left), HopcroftUllmanConstruction.build(node.right));
        } else if (node.type == Node.Type.STAR) {
            fSM = HopcroftUllmanConstruction.buildStar(HopcroftUllmanConstruction.build(node.left));
        } else if (node.type == Node.Type.GROUP) {
            return HopcroftUllmanConstruction.build(node.left);
        }
        return fSM;
    }

    public static FSM buildDot(FSM fSM, FSM fSM2) {
        FSM fSM3 = new FSM();
        int n = fSM.renameStates();
        fSM2.renameStates(n);
        stateiter.init(fSM.initials);
        while (stateiter.hasNext()) {
            fSM3.addInitialState(stateiter.next());
        }
        stateiter.init(fSM2.finals);
        while (stateiter.hasNext()) {
            fSM3.addFinalState(stateiter.next());
        }
        stateiter.init(fSM.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM.transitions, stateiter.next());
            while (transiter.hasNext()) {
                fSM3.addTransition(transiter.next());
            }
        }
        stateiter.init(fSM2.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM2.transitions, stateiter.next());
            while (transiter.hasNext()) {
                fSM3.addTransition(transiter.next());
            }
        }
        int n2 = 0;
        int n3 = 0;
        stateiter.init(fSM.finals);
        while (stateiter.hasNext()) {
            n2 = stateiter.next();
            stateiter2.init(fSM2.initials);
            while (stateiter2.hasNext()) {
                n3 = stateiter2.next();
                fSM3.addTransition(new Transition(n2, -1, -1, null, n3));
            }
        }
        return fSM3;
    }

    public static FSM buildPipe(FSM fSM, FSM fSM2) {
        int n;
        FSM fSM3 = new FSM();
        int n2 = fSM.renameStates();
        int n3 = fSM2.renameStates(n2);
        int n4 = n = n2 + n3;
        fSM3.addInitialState(n4);
        int n5 = n + 1;
        fSM3.addFinalState(n5);
        stateiter.init(fSM.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM.transitions, stateiter.next());
            while (transiter.hasNext()) {
                fSM3.addTransition(transiter.next());
            }
        }
        stateiter.init(fSM2.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM2.transitions, stateiter.next());
            while (transiter.hasNext()) {
                fSM3.addTransition(transiter.next());
            }
        }
        stateiter.init(fSM.initials);
        while (stateiter.hasNext()) {
            fSM3.addTransition(new Transition(n4, -1, -1, null, stateiter.next()));
        }
        stateiter.init(fSM2.initials);
        while (stateiter.hasNext()) {
            fSM3.addTransition(new Transition(n4, -1, -1, null, stateiter.next()));
        }
        stateiter.init(fSM.finals);
        while (stateiter.hasNext()) {
            fSM3.addTransition(new Transition(stateiter.next(), -1, -1, null, n5));
        }
        stateiter.init(fSM2.finals);
        while (stateiter.hasNext()) {
            fSM3.addTransition(new Transition(stateiter.next(), -1, -1, null, n5));
        }
        return fSM3;
    }

    public static FSM buildStar(FSM fSM) {
        int n;
        FSM fSM2 = new FSM();
        int n2 = n = fSM.renameStates();
        fSM2.addInitialState(n2);
        int n3 = n + 1;
        fSM2.addFinalState(n3);
        stateiter.init(fSM.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM.transitions, stateiter.next());
            while (transiter.hasNext()) {
                fSM2.addTransition(transiter.next());
            }
        }
        stateiter.init(fSM.initials);
        while (stateiter.hasNext()) {
            fSM2.addTransition(new Transition(n2, -1, -1, null, stateiter.next()));
        }
        stateiter.init(fSM.finals);
        while (stateiter.hasNext()) {
            int n4 = stateiter.next();
            fSM2.addTransition(new Transition(n4, -1, -1, null, n3));
            stateiter.init(fSM.initials);
            while (stateiter.hasNext()) {
                fSM2.addTransition(new Transition(n4, -1, -1, null, stateiter.next()));
            }
        }
        fSM2.addTransition(new Transition(n2, -1, -1, null, n3));
        return fSM2;
    }

    public static FSM buildSeg(Node node) {
        FSM fSM = new FSM();
        int n = 0;
        fSM.addInitialState(n);
        int n2 = 1;
        fSM.addFinalState(n2);
        fSM.addTransition(new Transition(n, Integer.parseInt(node.data), -1, null, n2));
        return fSM;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.exit(0);
        }
        Options options = new Options();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        for (Object object : Sigma.OPTIONS) {
            options.addOption(object);
        }
        options.addOption(new Option("regexp", true, "regular expression to be converted to NFA"));
        commandLine = gnuParser.parse(options, stringArray, false);
        if (commandLine.hasOption("regexp")) {
            Object object;
            String string = commandLine.getOptionValue("regexp");
            System.out.println(string);
            Scanner scanner = new Scanner(string);
            RegexpParser regexpParser = new RegexpParser(scanner);
            object = HopcroftUllmanConstruction.apply(regexpParser.parse());
            object = BrzozowskiMinimization.apply((FSM)object);
            System.out.println(object);
        }
    }
}

