/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.RealSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionIterator;
import edu.ucla.fsm.Weight;
import edu.ucla.fsm.WeightPush;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;

public class GenericBestPath {
    static StateIterator stateiter = new StateIterator();
    static TransitionIterator transiter = new TransitionIterator();
    static TIntArrayList queue = new TIntArrayList();
    static TIntHashSet enqueued = new TIntHashSet();
    public static TIntObjectHashMap<Weight> d = new TIntObjectHashMap();
    static TIntObjectHashMap<Weight> r = new TIntObjectHashMap();
    static Weight bestFinalCost = null;
    public static int maximumFinalVisits = -1;
    public static boolean verbose = false;

    public static Weight apply(FSM fSM, Semiring semiring) {
        return GenericBestPath.apply(fSM, semiring, 0.0);
    }

    public static Weight apply(FSM fSM, Semiring semiring, double d) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Transition transition = null;
        Weight weight = null;
        int n4 = 0;
        boolean bl = d > 0.0;
        queue.clear();
        enqueued.clear();
        GenericBestPath.d.clear();
        r.clear();
        stateiter.init(fSM.initials);
        while (stateiter.hasNext()) {
            n = stateiter.next();
            queue.add(n);
            enqueued.add(n);
            GenericBestPath.d.put(n, (Object)semiring.getOne());
            r.put(n, (Object)semiring.getOne());
        }
        block1: while (!queue.isEmpty()) {
            n2 = queue.remove(0);
            enqueued.remove(n2);
            weight = r.containsKey(n2) ? (Weight)r.get(n2) : semiring.getZero();
            r.put(n2, (Object)semiring.getZero());
            transiter.init(fSM.transitions, n2);
            while (transiter.hasNext()) {
                transition = transiter.next();
                n3 = transition.dest;
                Weight weight2 = (Weight)GenericBestPath.d.get(n3);
                if (weight2 == null) {
                    weight2 = semiring.getZero();
                }
                Weight weight3 = semiring.otimes(weight, transition.weight);
                Weight weight4 = semiring.oplus(weight2, weight3);
                if (!bl ? semiring.cmp(weight2, weight4) == 0 : semiring.delta(weight2, weight4) < d) continue;
                if (maximumFinalVisits >= 0 && fSM.finals.contains(n3) && ++n4 > maximumFinalVisits) break block1;
                GenericBestPath.d.put(n3, (Object)weight4);
                Weight weight5 = r.containsKey(n3) ? (Weight)r.get(n3) : semiring.getZero();
                r.put(n3, (Object)semiring.oplus(weight5, weight3));
                if (enqueued.contains(n3)) continue;
                queue.add(n3);
                enqueued.add(n3);
            }
        }
        if (verbose) {
            System.out.println("GenericBestPath: exiting main loop");
        }
        bestFinalCost = semiring.getZero();
        stateiter.init(fSM.finals);
        while (stateiter.hasNext()) {
            n = stateiter.next();
            bestFinalCost = semiring.oplus(GenericBestPath.d.contains(n) ? (Weight)GenericBestPath.d.get(n) : semiring.getZero(), bestFinalCost);
        }
        stateiter.init(fSM.finals);
        while (stateiter.hasNext()) {
            n = stateiter.next();
            if (!GenericBestPath.d.containsKey(n)) continue;
            GenericBestPath.d.put(n, (Object)bestFinalCost);
        }
        queue.clear();
        enqueued.clear();
        r.clear();
        maximumFinalVisits = -1;
        return bestFinalCost;
    }

    public static Weight getBestFinalCost() {
        return bestFinalCost;
    }

    public static void main(String[] stringArray) throws Exception {
        FSM fSM = new FSM();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        fSM.addInitialState(n);
        fSM.addFinalState(n4);
        double d = 2.0;
        fSM.addTransition(new Transition(n, 0, -1, new RealWeight(Math.exp(0.0)), n2));
        fSM.addTransition(new Transition(n2, 1, -1, new RealWeight(Math.exp(-d)), n2));
        fSM.addTransition(new Transition(n2, 2, -1, new RealWeight(Math.exp(-d)), n2));
        fSM.addTransition(new Transition(n2, 1, -1, new RealWeight(Math.exp(-d)), n3));
        fSM.addTransition(new Transition(n2, 2, -1, new RealWeight(Math.exp(-d)), n3));
        fSM.addTransition(new Transition(n3, 0, -1, new RealWeight(Math.exp(0.0)), n4));
        System.out.println(fSM);
        maximumFinalVisits = 100;
        GenericBestPath.apply(fSM, new RealSemiring(), 1.0E-20);
        System.out.println(GenericBestPath.d);
        maximumFinalVisits = 100;
        WeightPush.apply(fSM, new RealSemiring(), 1.0E-20);
        System.out.println(fSM);
        maximumFinalVisits = 100;
        GenericBestPath.apply(fSM, new RealSemiring(), 1.0E-20);
        System.out.println(GenericBestPath.d);
    }
}

