/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Alphabet;
import java.util.Arrays;
import java.util.LinkedList;

public class FeatureConverter {
    private static String STAR = "*";

    public static boolean[] toBoolean(int[] nArray, int[][] nArray2) {
        int n = nArray2.length;
        boolean[] blArray = new boolean[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!FeatureConverter.subsumes(nArray, nArray2[i])) continue;
            blArray[i] = true;
            bl = false;
        }
        if (bl) {
            return null;
        }
        return blArray;
    }

    public static boolean[][] toBoolean(int[] nArray, boolean[][] blArray) {
        int n = nArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            blArrayArray[i] = blArray[nArray[i]];
        }
        return blArrayArray;
    }

    public static int[] toSegments(int[] nArray, int[][] nArray2) {
        boolean[] blArray = FeatureConverter.toBoolean(nArray, nArray2);
        int n = blArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            ++n2;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            nArray3[n3++] = i;
        }
        return nArray3;
    }

    public static int[] toSegments(boolean[] blArray) {
        int n = blArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            nArray[n3++] = i;
        }
        return nArray;
    }

    public static int[][] toConstraint(int[] nArray, int[][] nArray2) {
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = nArray2[nArray[i]];
        }
        return nArrayArray;
    }

    public static int[] toConstraint(String string, Alphabet alphabet) {
        String string2 = string.replaceAll("[*]", "");
        String[] stringArray = string2.split("]");
        int[] nArray = new int[stringArray.length];
        Arrays.fill(nArray, -1);
        String string3 = null;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            string3 = stringArray[i] + "]";
            for (int j = 0; j < alphabet.naturalClassNames.length; ++j) {
                if (!alphabet.naturalClassNames[j].equals(string3)) continue;
                nArray[i] = j;
                continue block0;
            }
            System.out.println("Error: cannot find natural class matching: xx" + string3 + "xx");
            System.exit(1);
        }
        return nArray;
    }

    public static String[] toSymbols(boolean[] blArray, LinkedList<String> linkedList) {
        int n = 0;
        int n2 = blArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            stringArray[n3++] = linkedList.get(i);
        }
        return stringArray;
    }

    public static String toRegexp(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = blArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("|");
            }
            stringBuffer.append(i);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toRegexp(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = nArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("|");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toRegexp(int[][] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int[] nArray2 : nArray) {
            stringBuffer.append(FeatureConverter.toRegexp(nArray2));
        }
        return stringBuffer.toString();
    }

    public static String toRegexp(int[] nArray, int[][] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : nArray) {
            stringBuffer.append(FeatureConverter.toRegexp(nArray2[n]));
        }
        return stringBuffer.toString();
    }

    public static String toRegexp(int[] nArray, int[][] nArray2, boolean[] blArray) {
        if (blArray == null || nArray.length == 1) {
            return FeatureConverter.toRegexp(nArray, nArray2);
        }
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            stringBuffer.append(i);
            if (n2 < n - 1) {
                stringBuffer.append("|");
            }
            ++n2;
        }
        stringBuffer.append(")*");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = nArray.length;
        for (int i = 0; i < n3 - 1; ++i) {
            stringBuffer2.append(FeatureConverter.toRegexp(nArray2[nArray[i]]));
            stringBuffer2.append(stringBuffer);
        }
        stringBuffer2.append(FeatureConverter.toRegexp(nArray2[nArray[n3 - 1]]));
        return stringBuffer2.toString();
    }

    public static String toRegexp(int[] nArray, LinkedList<String> linkedList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        boolean bl = true;
        for (int n : nArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("|");
            }
            stringBuffer.append(linkedList.get(n));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toForm(int[] nArray, LinkedList<String> linkedList) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 1; i < nArray.length - 1; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(linkedList.get(nArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toSymbolConstraint(int[] nArray, int[][] nArray2, LinkedList<String> linkedList) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(STAR);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(FeatureConverter.toRegexp(nArray2[nArray[i]], linkedList));
        }
        return stringBuffer.toString();
    }

    public static String toFeatureConstraint(int[] nArray, int[][] nArray2, LinkedList<String> linkedList) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(STAR);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(FeatureConverter.toFeatureMatrix(nArray2[nArray[i]], linkedList));
        }
        return stringBuffer.toString();
    }

    public static String toFeatureConstraint(int[] nArray, String[] stringArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(STAR);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[nArray[i]]);
        }
        return stringBuffer.toString();
    }

    public static String toFeatureMatrix(int[] nArray, LinkedList<String> linkedList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || i == 0 && nArray[i] == -1) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[i] == 1 ? "+" : "-");
            stringBuffer.append(linkedList.get(i));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static int[] toFeatureArray(String string, LinkedList<String> linkedList) {
        int[] nArray = new int[linkedList.size()];
        String string2 = string.replaceAll("[*^]", "");
        if ((string2 = string2.replaceAll("[\\[\\]]", "")).equals("")) {
            string2 = "-" + linkedList.get(0);
        }
        String[] stringArray = string2.split(",");
        String string3 = null;
        String string4 = null;
        for (String string5 : stringArray) {
            string3 = string5.substring(0, 1);
            string4 = string5.substring(1, string5.length());
            nArray[linkedList.indexOf((Object)string4)] = string3.equals("+") ? 1 : (string3.equals("-") ? -1 : 0);
        }
        return nArray;
    }

    public static boolean subsumes(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0 || nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("consonantal");
        linkedList.add("sonorant");
        linkedList.add("voice");
        System.out.println(Arrays.toString(FeatureConverter.toFeatureArray("[^-sonorant,+voice]", linkedList)));
        System.out.println(Arrays.toString(FeatureConverter.toFeatureArray("[-consonantal,+voice]", linkedList)));
    }
}

