/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.TopologicalSort;
import edu.ucla.fsm.Transition;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;

public class FSMQuick {
    static StateIterator stateiter = new StateIterator();
    public TIntHashSet initials = null;
    public TIntHashSet finals = null;
    public Transition[][] transitions = null;
    public int[] topologicalOrder = null;
    int verbosity = 0;

    public FSMQuick() {
    }

    public FSMQuick(FSM fSM, Semiring semiring) {
        int n;
        fSM.renameStates();
        this.initials = (TIntHashSet)fSM.initials.clone();
        this.finals = (TIntHashSet)fSM.finals.clone();
        TIntArrayList tIntArrayList = TopologicalSort.apply(fSM);
        this.topologicalOrder = tIntArrayList.toNativeArray();
        int n2 = this.topologicalOrder.length;
        this.transitions = new Transition[n2][];
        for (n = 0; n < n2; ++n) {
            if (fSM.transitions.containsKey(n)) {
                Transition[] transitionArray = new Transition[((ArrayList)fSM.transitions.get(n)).size()];
                int n3 = 0;
                for (Transition transition : (ArrayList)fSM.transitions.get(n)) {
                    transitionArray[n3++] = new Transition(transition.src, transition.input, transition.output, transition.weight, transition.dest);
                }
                this.transitions[n] = transitionArray;
                continue;
            }
            this.transitions[n] = null;
        }
        if (this.verbosity > 0) {
            System.out.println("FSMQuick: " + fSM);
            System.out.println("initials: " + Arrays.toString(this.initials.toArray()));
            System.out.println("finals: " + Arrays.toString(this.finals.toArray()));
            System.out.println("topologicalOrder: " + Arrays.toString(this.topologicalOrder));
            System.out.println("transitions:");
            for (n = 0; n < this.transitions.length; ++n) {
                System.out.println("q=" + n + ":" + Arrays.toString(this.transitions[n]));
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\ndigraph G\n{\n");
        stringBuffer.append("graph [size = \"7.5,7.5\" rankdir = LR]\n");
        stringBuffer.append("node [shape = circle]\n");
        stateiter.init(this.initials);
        while (stateiter.hasNext()) {
            n = stateiter.next();
            stringBuffer.append(n);
            stringBuffer.append(" [style=bold");
            if (this.finals.contains(n)) {
                stringBuffer.append(" peripheries=2");
            }
            stringBuffer.append("]\n");
        }
        stateiter.init(this.finals);
        while (stateiter.hasNext()) {
            n = stateiter.next();
            if (this.initials.contains(n)) continue;
            stringBuffer.append(n);
            stringBuffer.append(" [peripheries=2]\n");
        }
        for (n = 0; n < this.transitions.length; ++n) {
            if (this.transitions[n] == null) continue;
            for (Transition transition : this.transitions[n]) {
                stringBuffer.append(transition.toString());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

