/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.IntegerWeight;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import edu.ucla.util.DefaultFileReader;
import java.io.File;
import java.io.FileReader;
import java.io.StreamTokenizer;

public class FSMFileReader
extends DefaultFileReader {
    static StreamTokenizer tokenizer;
    static int verbosity;

    public static FSM read(File file) throws Exception {
        tokenizer = new StreamTokenizer(new FileReader(file));
        FSMFileReader.initializeStreamTokenizer((StreamTokenizer)tokenizer);
        tokenizer.ordinaryChar(47);
        tokenizer.wordChars(47, 47);
        tokenizer.ordinaryChar(45);
        tokenizer.wordChars(45, 45);
        tokenizer.ordinaryChar(43);
        tokenizer.wordChars(43, 43);
        tokenizer.eolIsSignificant(true);
        FSM fSM = new FSM();
        Transition transition = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        Weight weight = null;
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("initial")) {
            System.out.println("Error reading FSM file: no initial states");
            System.exit(1);
        }
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("{")) {
            System.exit(1);
        }
        tokenizer.nextToken();
        while (!FSMFileReader.tokenizer.sval.equals("}")) {
            n = Integer.parseInt(FSMFileReader.tokenizer.sval);
            fSM.addInitialState(n);
            tokenizer.nextToken();
        }
        tokenizer.nextToken();
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("final")) {
            System.out.println("Error reading FSM file: no final states");
            System.exit(1);
        }
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("{")) {
            System.exit(1);
        }
        tokenizer.nextToken();
        while (!FSMFileReader.tokenizer.sval.equals("}")) {
            n = Integer.parseInt(FSMFileReader.tokenizer.sval);
            fSM.addFinalState(n);
            tokenizer.nextToken();
        }
        tokenizer.nextToken();
        tokenizer.nextToken();
        do {
            n = Integer.parseInt(FSMFileReader.tokenizer.sval);
            tokenizer.nextToken();
            if (!FSMFileReader.tokenizer.sval.equals("->")) {
                System.exit(1);
            }
            tokenizer.nextToken();
            n2 = Integer.parseInt(FSMFileReader.tokenizer.sval);
            boolean bl = false;
            tokenizer.nextToken();
            n3 = FSMFileReader.tokenizer.sval.equals(".") ? -1 : Integer.parseInt(FSMFileReader.tokenizer.sval);
            tokenizer.nextToken();
            if (FSMFileReader.tokenizer.ttype != 10 && !FSMFileReader.tokenizer.sval.equals("/")) {
                n5 = FSMFileReader.tokenizer.sval.equals(".") ? -1 : Integer.parseInt(FSMFileReader.tokenizer.sval);
                tokenizer.nextToken();
                if (FSMFileReader.tokenizer.ttype != 10 && !FSMFileReader.tokenizer.sval.equals("/")) {
                    n4 = FSMFileReader.tokenizer.sval.equals(".") ? -1 : Integer.parseInt(FSMFileReader.tokenizer.sval);
                    bl = true;
                    tokenizer.nextToken();
                } else {
                    n4 = n5;
                    bl = false;
                }
            }
            if (FSMFileReader.tokenizer.ttype != 10 && FSMFileReader.tokenizer.sval.equals("/")) {
                tokenizer.nextToken();
                weight = FSMFileReader.tokenizer.sval.contains(".") ? FSMFileReader.readRealWeight() : FSMFileReader.readIntegerWeight();
                tokenizer.nextToken();
            } else {
                weight = null;
            }
            if (bl) {
                System.out.println("Error in FSMFileReader: projection part of transition label not implemented");
                transition = null;
                System.exit(1);
            } else {
                transition = new Transition(n, n3, n4, weight, n2);
            }
            fSM.addTransition(transition);
            tokenizer.nextToken();
        } while (FSMFileReader.tokenizer.ttype != -1 && FSMFileReader.tokenizer.ttype != 10);
        return fSM;
    }

    private static IntegerWeight readIntegerWeight() throws Exception {
        return new IntegerWeight(Integer.parseInt(FSMFileReader.tokenizer.sval));
    }

    private static RealWeight readRealWeight() throws Exception {
        return new RealWeight(Double.parseDouble(FSMFileReader.tokenizer.sval));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            FSM fSM = FSMFileReader.read(new File(stringArray[0]));
            System.out.println(fSM);
        }
    }

    static {
        verbosity = 0;
    }
}

