/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.AccessibleStates;
import edu.ucla.fsm.GenericBestPath;
import edu.ucla.fsm.RealSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.SymbolTable;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.WeightMapper;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class FSM
implements Serializable {
    public static final int EPSILON = -1;
    public TIntHashSet initials = null;
    public TIntHashSet finals = null;
    public TIntObjectHashMap<ArrayList<Transition>> transitions = null;
    private static boolean verbose = false;

    public FSM() {
        this.initials = new TIntHashSet();
        this.finals = new TIntHashSet();
        this.transitions = new TIntObjectHashMap();
    }

    public FSM(TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2, TIntObjectHashMap<ArrayList<Transition>> tIntObjectHashMap) {
        this.initials = tIntHashSet;
        this.finals = tIntHashSet2;
        this.transitions = tIntObjectHashMap;
    }

    public void addInitialState(int n) {
        if (!this.initials.contains(n)) {
            this.initials.add(n);
        }
    }

    public void addFinalState(int n) {
        if (!this.finals.contains(n)) {
            this.finals.add(n);
        }
    }

    public void addTransition(Transition transition) {
        int n = transition.src;
        ArrayList<Transition> arrayList = (ArrayList<Transition>)this.transitions.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<Transition>();
            this.transitions.put(n, arrayList);
        }
        arrayList.add(transition);
    }

    public void removeTransition(Transition transition) {
        int n = transition.src;
        ArrayList arrayList = (ArrayList)this.transitions.get(n);
        if (arrayList == null) {
            return;
        }
        int n2 = arrayList.indexOf(transition);
        if (n2 != -1) {
            arrayList.remove(n2);
        }
    }

    public static FSM linearAcceptor(int[] nArray) {
        return FSM.linearAcceptor(nArray, null);
    }

    public static FSM linearAcceptor(int[] nArray, int[] nArray2) {
        FSM fSM = new FSM();
        int n = 0;
        fSM.addInitialState(n);
        int n2 = n + 1;
        for (int i = 0; i < nArray.length; ++i) {
            fSM.addTransition(new Transition(n, nArray[i], nArray2 == null ? -1 : nArray2[i], null, n2));
            n = n2++;
        }
        fSM.addFinalState(--n2);
        return fSM;
    }

    public static FSM sigmaStarAcceptor(SymbolTable symbolTable) {
        FSM fSM = new FSM();
        int n = 0;
        fSM.addInitialState(n);
        fSM.addFinalState(n);
        TIntIterator tIntIterator = symbolTable.getSigma().iterator();
        while (tIntIterator.hasNext()) {
            fSM.addTransition(new Transition(n, tIntIterator.next(), -1, null, n));
        }
        return fSM;
    }

    public static FSM boundedSigmaStarAcceptor(SymbolTable symbolTable) {
        FSM fSM = new FSM();
        int n = 0;
        fSM.addInitialState(n);
        int n2 = 1;
        int n3 = 2;
        fSM.addFinalState(n3);
        fSM.addTransition(new Transition(n, symbolTable.getBoundarySymbol(), -1, null, n2));
        fSM.addTransition(new Transition(n2, symbolTable.getBoundarySymbol(), -1, null, n3));
        for (int n4 : symbolTable.getSigma()) {
            if (n4 == symbolTable.getBoundarySymbol()) continue;
            fSM.addTransition(new Transition(n2, n4, -1, null, n2));
        }
        return fSM;
    }

    public static FSM boundedTrellisAcceptor(SymbolTable symbolTable, int n, int n2) {
        FSM fSM = new FSM();
        int n3 = 0;
        int n4 = n3++;
        fSM.addInitialState(n4);
        int n5 = n3++;
        fSM.addFinalState(n5);
        int n6 = n3++;
        fSM.addTransition(new Transition(n4, symbolTable.getBoundarySymbol(), -1, null, n6));
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            n7 = n3++;
            for (int n8 : symbolTable.getSigma()) {
                if (n8 == symbolTable.getBoundarySymbol()) continue;
                fSM.addTransition(new Transition(n6, n8, -1, null, n7));
            }
            if (i >= n) {
                fSM.addTransition(new Transition(n6, symbolTable.getBoundarySymbol(), -1, null, n5));
            }
            n6 = n7;
        }
        fSM.addTransition(new Transition(n6, symbolTable.getBoundarySymbol(), -1, null, n5));
        return fSM;
    }

    public int renameStates() {
        return this.renameStates(0);
    }

    public int renameStates(int n) {
        TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
        int n22 = 0;
        int n3 = n;
        TIntHashSet tIntHashSet = new TIntHashSet(this.initials.size());
        for (int n22 : this.initials) {
            if (tIntIntHashMap.containsKey(n22)) {
                tIntHashSet.add(tIntIntHashMap.get(n22));
                continue;
            }
            tIntHashSet.add(n3);
            tIntIntHashMap.put(n22, n3++);
        }
        TIntIterator tIntIterator = new TIntHashSet(this.finals.size());
        for (int n22 : this.finals) {
            if (tIntIntHashMap.containsKey(n22)) {
                tIntIterator.add(tIntIntHashMap.get(n22));
                continue;
            }
            tIntIterator.add(n3);
            tIntIntHashMap.put(n22, n3++);
        }
        int n4 = 0;
        int n5 = 0;
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap(this.transitions.size());
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            n22 = tIntObjectIterator.key();
            if (tIntIntHashMap.containsKey(n22)) {
                n4 = tIntIntHashMap.get(n22);
            } else {
                n4 = n3;
                tIntIntHashMap.put(n22, n3++);
            }
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.src = n4;
                if (tIntIntHashMap.containsKey(transition.dest)) {
                    n5 = tIntIntHashMap.get(transition.dest);
                } else {
                    n5 = n3;
                    tIntIntHashMap.put(transition.dest, n3++);
                }
                transition.dest = n5;
            }
            tIntObjectHashMap.put(n4, tIntObjectIterator.value());
        }
        this.initials = tIntHashSet;
        this.finals = tIntIterator;
        this.transitions = tIntObjectHashMap;
        return tIntIntHashMap.size();
    }

    public FSM reverse() {
        if (verbose) {
            System.out.println("reversing ...");
        }
        TIntHashSet tIntHashSet = this.initials;
        this.initials = this.finals;
        this.finals = tIntHashSet;
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap(this.transitions.size());
        ArrayList<Transition> arrayList = null;
        int n = 0;
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                n = transition.src;
                transition.src = transition.dest;
                transition.dest = n;
                arrayList = (ArrayList<Transition>)tIntObjectHashMap.get(transition.src);
                if (arrayList == null) {
                    arrayList = new ArrayList<Transition>();
                    tIntObjectHashMap.put(transition.src, arrayList);
                }
                arrayList.add(transition);
            }
        }
        this.transitions = tIntObjectHashMap;
        if (verbose) {
            System.out.println("done");
        }
        return this;
    }

    public FSM prune() {
        if (verbose) {
            System.out.println("pruning ...");
        }
        TIntHashSet tIntHashSet = null;
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        TIntObjectHashMap tIntObjectHashMap2 = new TIntObjectHashMap();
        TIntHashSet tIntHashSet2 = null;
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                tIntHashSet2 = (TIntHashSet)tIntObjectHashMap.get(transition.src);
                if (tIntHashSet2 == null) {
                    tIntHashSet2 = new TIntHashSet();
                    tIntObjectHashMap.put(transition.src, (Object)tIntHashSet2);
                }
                tIntHashSet2.add(transition.dest);
                tIntHashSet2 = (TIntHashSet)tIntObjectHashMap2.get(transition.dest);
                if (tIntHashSet2 == null) {
                    tIntHashSet2 = new TIntHashSet();
                    tIntObjectHashMap2.put(transition.dest, (Object)tIntHashSet2);
                }
                tIntHashSet2.add(transition.src);
            }
        }
        tIntHashSet = AccessibleStates.apply(this.finals, (TIntObjectHashMap<TIntHashSet>)tIntObjectHashMap2);
        tIntObjectIterator = new TIntHashSet();
        for (int n : this.initials) {
            if (!tIntHashSet.contains(n)) continue;
            tIntObjectIterator.add(n);
        }
        this.initials = null;
        this.initials = tIntObjectIterator;
        this.pruneTransitions(tIntHashSet);
        tIntHashSet = AccessibleStates.apply(this.initials, (TIntObjectHashMap<TIntHashSet>)tIntObjectHashMap);
        TIntIterator tIntIterator = new TIntHashSet();
        for (int n : this.finals) {
            if (!tIntHashSet.contains(n)) continue;
            tIntIterator.add(n);
        }
        this.finals = null;
        this.finals = tIntIterator;
        this.pruneTransitions(tIntHashSet);
        if (verbose) {
            System.out.println("done");
        }
        return this;
    }

    public void pruneTransitions(TIntHashSet tIntHashSet) {
        if (verbose) {
            System.out.println("removing dead transitions ...");
        }
        Transition transition = null;
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        Iterator iterator = null;
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            if (!tIntHashSet.contains(tIntObjectIterator.key())) {
                tIntObjectIterator.remove();
                continue;
            }
            iterator = ((ArrayList)tIntObjectIterator.value()).iterator();
            for (int j = ((ArrayList)tIntObjectIterator.value()).size() - 1; j >= 0; --j) {
                transition = (Transition)iterator.next();
                if (tIntHashSet.contains(transition.dest)) continue;
                iterator.remove();
            }
        }
        if (verbose) {
            System.out.println("done");
        }
    }

    public FSM removeEpsilonTransitions() {
        return this;
    }

    public void sortTransitions(Comparator<Transition> comparator) {
        ArrayList arrayList = null;
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        block4: while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            arrayList = (ArrayList)tIntObjectIterator.value();
            switch (arrayList.size()) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    Transition transition;
                    Transition transition2 = (Transition)arrayList.get(0);
                    if (comparator.compare(transition2, transition = (Transition)arrayList.get(1)) != 1) continue block4;
                    arrayList.set(0, transition);
                    arrayList.set(1, transition2);
                    continue block4;
                }
            }
            Collections.sort(arrayList, comparator);
        }
    }

    public double countPaths() {
        FSM fSM = this.copy();
        RealWeight realWeight = new RealWeight(1.0);
        Object object = fSM.transitions.iterator();
        while (object.hasNext()) {
            object.advance();
            for (Transition transition : (ArrayList)object.value()) {
                transition.weight = realWeight;
            }
        }
        object = (RealWeight)GenericBestPath.apply(fSM, new RealSemiring());
        return ((RealWeight)object).doubleValue();
    }

    public FSM proj1to2() {
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.output = transition.input;
                transition.input = -1;
            }
        }
        return this;
    }

    public FSM proj2to1() {
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.input = transition.output;
                transition.output = -1;
            }
        }
        return this;
    }

    public FSM copy1to2() {
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.output = transition.input;
                transition.output = -1;
            }
        }
        return this;
    }

    public FSM copy2to1() {
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.input = transition.output;
            }
        }
        return this;
    }

    public FSM resetWeights(Object object) {
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.weight = null;
            }
        }
        return this;
    }

    public FSM mapWeights(WeightMapper weightMapper) {
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        for (int i = this.transitions.size() - 1; i >= 0; --i) {
            tIntObjectIterator.advance();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                transition.weight = weightMapper.apply(transition.weight);
            }
        }
        return this;
    }

    public FSM copy() {
        TIntHashSet tIntHashSet = (TIntHashSet)this.initials.clone();
        TIntHashSet tIntHashSet2 = (TIntHashSet)this.finals.clone();
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        ArrayList<Transition> arrayList = null;
        TIntObjectIterator tIntObjectIterator = this.transitions.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            arrayList = new ArrayList<Transition>();
            for (Transition transition : (ArrayList)tIntObjectIterator.value()) {
                arrayList.add(new Transition(transition.src, transition.input, transition.output, transition.weight, transition.dest));
            }
            tIntObjectHashMap.put(tIntObjectIterator.key(), arrayList);
        }
        return new FSM(tIntHashSet, tIntHashSet2, (TIntObjectHashMap<ArrayList<Transition>>)tIntObjectHashMap);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\ndigraph G\n{\n");
        stringBuffer.append("graph [size = \"7.5,7.5\" rankdir = LR]\n");
        stringBuffer.append("node [shape = circle]\n");
        int n2 = 0;
        for (int n2 : this.initials) {
            stringBuffer.append(n2);
            stringBuffer.append(" [style=bold");
            if (this.finals.contains(n2)) {
                stringBuffer.append(" peripheries=2");
            }
            stringBuffer.append("]\n");
        }
        for (int n2 : this.finals) {
            if (this.initials.contains(n2)) continue;
            stringBuffer.append(n2);
            stringBuffer.append(" [peripheries=2]\n");
        }
        TIntIterator tIntIterator = this.transitions.iterator();
        while (tIntIterator.hasNext()) {
            tIntIterator.advance();
            for (Transition transition : (ArrayList)tIntIterator.value()) {
                stringBuffer.append(transition.toString());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

