/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Weight;
import java.util.Arrays;

public class ExpectationSemiringWeight
extends Weight {
    public double p = 0.0;
    public double[] pv = null;
    public static final double MIN_VALUE = Double.MIN_VALUE;

    public ExpectationSemiringWeight(int n) {
        this.p = 0.0;
        this.pv = new double[n];
    }

    public ExpectationSemiringWeight(double d, double[] dArray) {
        this.p = d;
        this.pv = dArray;
    }

    public ExpectationSemiringWeight(double[] dArray, int[] nArray) {
        int n;
        int n2 = dArray.length;
        double d = 0.0;
        for (n = n2 - 1; n >= 0; --n) {
            if (nArray[n] == 0) continue;
            d += dArray[n] * (double)nArray[n];
        }
        this.p = Math.exp(-d);
        if (Double.isNaN(this.p) || Double.isInfinite(this.p)) {
            this.p = Double.MIN_VALUE;
        }
        this.pv = new double[n2];
        for (n = n2 - 1; n >= 0; --n) {
            if (nArray[n] == 0) continue;
            this.pv[n] = this.p * (double)nArray[n];
        }
    }

    @Override
    public int hashCode() {
        return 7 * (int)this.p + 31 * Arrays.hashCode(this.pv);
    }

    @Override
    public int compareTo(Object object) {
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)object;
        if (this.p < expectationSemiringWeight.p) {
            return -1;
        }
        if (this.p > expectationSemiringWeight.p) {
            return 1;
        }
        if (this.pv == null && expectationSemiringWeight.pv != null) {
            return -1;
        }
        if (this.pv != null && expectationSemiringWeight.pv == null) {
            return 1;
        }
        if (this.pv != null && expectationSemiringWeight.pv != null) {
            if (Arrays.equals(this.pv, expectationSemiringWeight.pv)) {
                return 0;
            }
            int n = this.pv.length;
            for (int i = 0; i < n; ++i) {
                if (this.pv[i] < expectationSemiringWeight.pv[i]) {
                    return -1;
                }
                if (!(this.pv[1] > expectationSemiringWeight.pv[i])) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExpectationSemiringWeight)) {
            return false;
        }
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)object;
        if (this.p != expectationSemiringWeight.p) {
            return false;
        }
        return Arrays.equals(this.pv, expectationSemiringWeight.pv);
    }

    @Override
    public Weight copy() {
        double d = this.p;
        double[] dArray = this.pv == null ? null : Arrays.copyOf(this.pv, this.pv.length);
        return new ExpectationSemiringWeight(d, dArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.p);
        stringBuffer.append(",");
        if (this.pv != null) {
            stringBuffer.append(Arrays.toString(this.pv));
        } else {
            stringBuffer.append(this.pv);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

