/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.ExpectationSemiringWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;
import java.util.Arrays;

public class ExpectationSemiring
extends Semiring {
    public static int N = 0;
    public static final ExpectationSemiringWeight ZERO = null;
    public static final ExpectationSemiringWeight ONE = new ExpectationSemiringWeight(1.0, null);
    public static final double MIN_VALUE = Double.MIN_VALUE;

    public ExpectationSemiring(int n) {
        N = n;
    }

    @Override
    public Weight otimes(Weight weight, Weight weight2) {
        double[] dArray;
        if (weight == null || weight2 == null) {
            return ZERO;
        }
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        ExpectationSemiringWeight expectationSemiringWeight2 = (ExpectationSemiringWeight)weight2;
        if (expectationSemiringWeight2 == ONE) {
            return expectationSemiringWeight;
        }
        if (expectationSemiringWeight == ONE) {
            return expectationSemiringWeight2;
        }
        double d = expectationSemiringWeight.p;
        double d2 = expectationSemiringWeight2.p;
        double d3 = d * d2;
        if (Double.isNaN(d3) || Double.isInfinite(d3)) {
            d3 = Double.MIN_VALUE;
        }
        boolean bl = (dArray = expectationSemiringWeight.pv) == null;
        double[] dArray2 = expectationSemiringWeight2.pv;
        boolean bl2 = dArray2 == null;
        double[] dArray3 = new double[N];
        for (int i = N - 1; i >= 0; --i) {
            if (!bl) {
                int n = i;
                dArray3[n] = dArray3[n] + d2 * dArray[i];
            }
            if (!bl2) {
                int n = i;
                dArray3[n] = dArray3[n] + d * dArray2[i];
            }
            if (!Double.isNaN(dArray3[i]) && !Double.isInfinite(dArray3[i])) continue;
            dArray3[i] = Double.MIN_VALUE;
        }
        return new ExpectationSemiringWeight(d3, dArray3);
    }

    @Override
    public Weight otimesPlusInto(Weight weight, Weight weight2, Weight weight3) {
        if (weight == null || weight2 == null) {
            return weight3;
        }
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        double d = expectationSemiringWeight.p;
        double[] dArray = expectationSemiringWeight.pv;
        boolean bl = dArray == null;
        ExpectationSemiringWeight expectationSemiringWeight2 = (ExpectationSemiringWeight)weight2;
        double d2 = expectationSemiringWeight2.p;
        double[] dArray2 = expectationSemiringWeight2.pv;
        boolean bl2 = dArray2 == null;
        ExpectationSemiringWeight expectationSemiringWeight3 = (ExpectationSemiringWeight)weight3;
        if (expectationSemiringWeight3 == null) {
            expectationSemiringWeight3 = new ExpectationSemiringWeight(d * d2 + 0.0, null);
        } else {
            expectationSemiringWeight3.p += d * d2;
        }
        if (bl && bl2) {
            return expectationSemiringWeight3;
        }
        double[] dArray3 = null;
        if (expectationSemiringWeight3.pv == null) {
            dArray3 = new double[N];
            expectationSemiringWeight3.pv = dArray3;
        } else {
            dArray3 = expectationSemiringWeight3.pv;
        }
        for (int i = N - 1; i >= 0; --i) {
            if (!bl) {
                int n = i;
                dArray3[n] = dArray3[n] + d2 * dArray[i];
            }
            if (bl2) continue;
            int n = i;
            dArray3[n] = dArray3[n] + d * dArray2[i];
        }
        return expectationSemiringWeight3;
    }

    @Override
    public Weight oplus(Weight weight, Weight weight2) {
        if (weight2 == null) {
            return weight;
        }
        if (weight == null) {
            return weight2;
        }
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        double[] dArray = expectationSemiringWeight.pv;
        boolean bl = dArray == null;
        ExpectationSemiringWeight expectationSemiringWeight2 = (ExpectationSemiringWeight)weight2;
        double[] dArray2 = expectationSemiringWeight2.pv;
        boolean bl2 = dArray2 == null;
        double d = expectationSemiringWeight.p + expectationSemiringWeight2.p;
        double[] dArray3 = new double[N];
        for (int i = N - 1; i >= 0; --i) {
            if (!bl) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i];
            }
            if (bl2) continue;
            int n = i;
            dArray3[n] = dArray3[n] + dArray2[i];
        }
        return new ExpectationSemiringWeight(d, dArray3);
    }

    @Override
    public Weight oplusInto(Weight weight, Weight weight2) {
        if (weight == null) {
            return weight2;
        }
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        double d = expectationSemiringWeight.p;
        double[] dArray = expectationSemiringWeight.pv;
        boolean bl = dArray == null;
        ExpectationSemiringWeight expectationSemiringWeight2 = (ExpectationSemiringWeight)weight2;
        if (expectationSemiringWeight2 == null) {
            expectationSemiringWeight2 = new ExpectationSemiringWeight(d + 0.0, null);
        } else {
            expectationSemiringWeight2.p += d;
        }
        if (bl) {
            return expectationSemiringWeight2;
        }
        double[] dArray2 = null;
        if (expectationSemiringWeight2.pv == null) {
            dArray2 = new double[N];
            System.arraycopy(dArray, 0, dArray2, 0, N);
            expectationSemiringWeight2.pv = dArray2;
        } else {
            dArray2 = expectationSemiringWeight2.pv;
            for (int i = N - 1; i >= 0; --i) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[i];
            }
        }
        return expectationSemiringWeight2;
    }

    @Override
    public Weight odiv(Weight weight, Weight weight2) {
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        ExpectationSemiringWeight expectationSemiringWeight2 = (ExpectationSemiringWeight)weight2;
        double d = expectationSemiringWeight.p / expectationSemiringWeight2.p;
        double[] dArray = Arrays.copyOf(expectationSemiringWeight.pv, N);
        int n = 0;
        while (n < N) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / expectationSemiringWeight2.p;
        }
        return new ExpectationSemiringWeight(d, dArray);
    }

    public Weight mult(double d, Weight weight) {
        if (weight == null) {
            return weight;
        }
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        double d2 = d * expectationSemiringWeight.p;
        double[] dArray = null;
        if (expectationSemiringWeight.pv != null) {
            int n = expectationSemiringWeight.pv.length;
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = d * expectationSemiringWeight.pv[i];
            }
        }
        return new ExpectationSemiringWeight(d2, dArray);
    }

    @Override
    public int cmp(Weight weight, Weight weight2) {
        System.out.println("ExpectationSemiring.cmp() not implemented");
        System.exit(1);
        return 0;
    }

    @Override
    public double delta(Weight weight, Weight weight2) {
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        if (expectationSemiringWeight == null) {
            return Double.MAX_VALUE;
        }
        ExpectationSemiringWeight expectationSemiringWeight2 = (ExpectationSemiringWeight)weight2;
        if (expectationSemiringWeight2 == null) {
            return expectationSemiringWeight.p;
        }
        return Math.abs(expectationSemiringWeight.p - expectationSemiringWeight2.p);
    }

    @Override
    public Weight getOne() {
        return ONE;
    }

    @Override
    public Weight getZero() {
        return ZERO;
    }

    @Override
    public Weight copy(Weight weight) {
        ExpectationSemiringWeight expectationSemiringWeight = (ExpectationSemiringWeight)weight;
        if (expectationSemiringWeight == null) {
            return null;
        }
        if (expectationSemiringWeight.pv == null) {
            return new ExpectationSemiringWeight(expectationSemiringWeight.p, expectationSemiringWeight.pv);
        }
        ExpectationSemiringWeight expectationSemiringWeight2 = new ExpectationSemiringWeight(N);
        expectationSemiringWeight2.p = expectationSemiringWeight.p;
        System.arraycopy(expectationSemiringWeight.pv, 0, expectationSemiringWeight2.pv, 0, N);
        return expectationSemiringWeight2;
    }
}

