/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.FeatureConverter;
import edu.ucla.fsm.NaturalClass;
import edu.ucla.util.BooleanArrayComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

public class EnumerateNaturalClasses2 {
    static TreeSet<boolean[]> denotationSet = new TreeSet(new BooleanArrayComparator());
    static LinkedList<int[]> atoms = new LinkedList();
    static LinkedList<int[]> oldMatrixList = new LinkedList();
    static LinkedList<int[]> newMatrixList = new LinkedList();
    public static LinkedList<NaturalClass> naturalClasses = new LinkedList();
    public static int number_of_natural_classes = 0;
    public static int number_of_core_classes = 0;
    static int verbosity = 0;

    public static void apply(LinkedList<String> linkedList, int[][] nArray, int n, boolean bl) {
        Object object;
        Object object3;
        denotationSet.clear();
        atoms.clear();
        oldMatrixList.clear();
        newMatrixList.clear();
        naturalClasses.clear();
        boolean[] blArray = null;
        for (int[] object22 : nArray) {
            blArray = FeatureConverter.toBoolean(object22, nArray);
            if (blArray == null || denotationSet.contains(blArray)) continue;
            atoms.add(object22);
            EnumerateNaturalClasses2.add(FeatureConverter.toFeatureMatrix(EnumerateNaturalClasses2.simplify(object22, nArray), linkedList), blArray);
        }
        newMatrixList.addAll(atoms);
        do {
            oldMatrixList.clear();
            oldMatrixList.addAll(newMatrixList);
            newMatrixList.clear();
            object3 = oldMatrixList.iterator();
            while (object3.hasNext()) {
                int[] nArray2 = (int[])object3.next();
                for (int[] nArray3 : atoms) {
                    object = EnumerateNaturalClasses2.merge(nArray2, nArray3);
                    if (object == null || (blArray = FeatureConverter.toBoolean(object, nArray)) == null || denotationSet.contains(blArray)) continue;
                    newMatrixList.add((int[])object);
                    EnumerateNaturalClasses2.add(FeatureConverter.toFeatureMatrix(EnumerateNaturalClasses2.simplify(object, nArray), linkedList), blArray);
                }
            }
        } while (!newMatrixList.isEmpty());
        number_of_core_classes = naturalClasses.size();
        if (bl) {
            object3 = new LinkedList();
            String string = null;
            boolean[] blArray2 = null;
            Iterator iterator = naturalClasses.iterator();
            while (iterator.hasNext()) {
                object = (NaturalClass)iterator.next();
                blArray2 = EnumerateNaturalClasses2.inverse(object.denotation);
                blArray2[0] = false;
                if (denotationSet.contains(blArray2) || Alphabet.size(blArray2) < 1) continue;
                string = object.name.substring(0, 1) + "^" + object.name.substring(1);
                ((LinkedList)object3).add(new NaturalClass(string, null, blArray2));
                denotationSet.add(blArray2);
            }
            naturalClasses.addAll((Collection<NaturalClass>)object3);
        }
        number_of_natural_classes = naturalClasses.size();
        if (verbosity > 5) {
            for (NaturalClass naturalClass : naturalClasses) {
                System.out.println(naturalClass.name + "\t" + Arrays.toString(naturalClass.denotation));
            }
        }
        for (NaturalClass naturalClass : naturalClasses) {
            naturalClass.features = FeatureConverter.toFeatureArray(naturalClass.name, linkedList);
        }
        Collections.sort(naturalClasses);
        object3 = naturalClasses.get(0);
        boolean[] blArray3 = new boolean[((NaturalClass)object3).denotation.length];
        blArray3[0] = true;
        object3 = null;
        for (NaturalClass naturalClass : naturalClasses) {
            if (!Arrays.equals(naturalClass.denotation, blArray3)) continue;
            object3 = naturalClass;
            break;
        }
        naturalClasses.remove(object3);
        naturalClasses.addFirst((NaturalClass)object3);
    }

    public static void add(String string, boolean[] blArray) {
        naturalClasses.add(new NaturalClass(string, null, blArray));
        denotationSet.add(blArray);
    }

    public static int[] merge(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = Arrays.copyOf(nArray, nArray.length);
        for (n = nArray3.length - 1; n >= 0; --n) {
            if (nArray[n] == nArray2[n]) continue;
            nArray3[n] = 0;
        }
        n = 0;
        for (int i = nArray3.length - 1; i >= 0; --i) {
            if (nArray3[i] == 0) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            return null;
        }
        return nArray3;
    }

    public static boolean[] inverse(boolean[] blArray) {
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        for (int i = n - 1; i >= 0; --i) {
            blArray2[i] = !blArray[i];
        }
        return blArray2;
    }

    public static int[] simplify(int[] nArray, int[][] nArray2) {
        if (verbosity > 9) {
            System.out.println("simplifying " + Arrays.toString(nArray));
        }
        boolean[] blArray = FeatureConverter.toBoolean(nArray, nArray2);
        int[] nArray3 = Arrays.copyOf(nArray, nArray.length);
        boolean[] blArray2 = null;
        int n = nArray.length;
        int n2 = 0;
        boolean bl = false;
        do {
            bl = false;
            for (int i = n - 1; i >= 0; --i) {
                if (nArray3[i] == 0) continue;
                n2 = nArray3[i];
                nArray3[i] = 0;
                if (verbosity > 9) {
                    System.out.print("\t" + n2 + " -> " + 0 + " at position " + i + "?");
                }
                if (!Arrays.equals(blArray, blArray2 = FeatureConverter.toBoolean(nArray3, nArray2))) {
                    nArray3[i] = n2;
                    if (verbosity <= 9) continue;
                    System.out.println("\tno");
                    continue;
                }
                bl = true;
                if (verbosity <= 9) continue;
                System.out.println("\tyes");
            }
        } while (bl);
        if (verbosity > 9) {
            System.out.println("\t\t" + Arrays.toString(nArray3));
        }
        return nArray3;
    }
}

