/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import cern.jet.random.Poisson;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.CorpusReader;
import edu.ucla.fsm.FeatureMatrixReader;
import edu.ucla.util.CartesianProductIterator;
import edu.ucla.util.Counter;
import edu.ucla.util.DiscreteDistribution;
import edu.ucla.util.IntArrayComparator;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class Corpus {
    public int N = 0;
    public CartesianProductIterator CPI = null;
    public int[] empiricalLengthDistrib = null;
    public int size = 0;
    public boolean storeData = false;
    public TreeMap<int[], Counter> data = null;
    public int data_size = 0;
    public int total_data_freq;
    public int[][] data_key = null;
    public int[] data_freq = null;
    public LinkedList<int[]> rawData = null;
    int verbosity = 10;

    public Corpus(int n, boolean bl) {
        this.N = n;
        this.storeData = bl;
        this.empiricalLengthDistrib = new int[0];
        this.size = 0;
        if (bl) {
            this.data = new TreeMap(new IntArrayComparator());
            this.rawData = new LinkedList();
        }
        this.reset();
    }

    public void reset() {
        this.empiricalLengthDistrib = new int[0];
        this.size = 0;
        if (this.data != null) {
            this.data.clear();
        }
        if (this.rawData != null) {
            this.rawData.clear();
        }
    }

    public void compile() {
        this.data_size = this.data.size();
        this.data_key = new int[this.data_size][];
        this.data_freq = new int[this.data_size];
        this.total_data_freq = 0;
        int n = 0;
        for (Map.Entry<int[], Counter> entry : this.data.entrySet()) {
            this.data_key[n] = entry.getKey();
            this.data_freq[n] = entry.getValue().intValue();
            this.total_data_freq += this.data_freq[n];
            ++n;
        }
    }

    public void updateCounts(int[] nArray, int n, int n2) {
        this.updateCounts(nArray, n, n2, 1);
    }

    public void updateCounts(int[] nArray, int n, int n2, int n3) {
        int[] nArray2;
        if (n < 0 || n > n2) {
            System.out.println("Incorrect bounds for updateCounts()");
        }
        this.size += n3;
        int n4 = n2 - n - 2;
        if (this.empiricalLengthDistrib.length > n4) {
            int n5 = n4;
            this.empiricalLengthDistrib[n5] = this.empiricalLengthDistrib[n5] + n3;
        } else {
            nArray2 = new int[n4 + 1];
            System.arraycopy(this.empiricalLengthDistrib, 0, nArray2, 0, this.empiricalLengthDistrib.length);
            nArray2[n4] = n3;
            this.empiricalLengthDistrib = nArray2;
        }
        if (this.storeData) {
            nArray2 = new int[n2 - n];
            System.arraycopy(nArray, 0, nArray2, 0, n2 - n);
            if (this.data.containsKey(nArray2)) {
                this.data.get((Object)nArray2).value += n3;
            } else {
                this.data.put(nArray2, new Counter(n3));
            }
            this.rawData.add(nArray2);
        }
    }

    public int count1(int[] nArray, boolean[][] blArray) {
        return this.count1(nArray, blArray, null);
    }

    public int count1(int[] nArray, boolean[][] blArray, boolean[] blArray2) {
        switch (blArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.count1(nArray, blArray[0], blArray2);
            }
            case 2: {
                return this.count1(nArray, blArray[0], blArray[1], blArray2);
            }
            case 3: {
                return this.count1(nArray, blArray[0], blArray[1], blArray[2], blArray2);
            }
            case 4: {
                return this.count1(nArray, blArray[0], blArray[1], blArray[2], blArray[3], blArray2);
            }
        }
        return this.count1Default(nArray, blArray, blArray2);
    }

    private int count1(int[] nArray, boolean[] blArray, boolean[] blArray2) {
        int n = 0;
        for (int n2 : nArray) {
            if (blArray2 != null && !blArray2[n2] || !blArray[n2]) continue;
            ++n;
        }
        return n;
    }

    private int count1(int[] nArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        int n = 0;
        int n2 = -1;
        for (int n3 : nArray) {
            if (blArray3 != null && !blArray3[n3]) continue;
            if (n2 != -1 && blArray[n2] && blArray2[n3]) {
                ++n;
            }
            n2 = n3;
        }
        return n;
    }

    private int count1(int[] nArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, boolean[] blArray4) {
        boolean bl = blArray4 != null;
        int n = 0;
        int n2 = nArray.length;
        int n3 = -1;
        int n4 = -1;
        for (int n5 : nArray) {
            if (blArray4 != null && !blArray4[n5]) continue;
            if (n3 != -1 && n4 != -1 && blArray[n3] && blArray2[n4] && blArray3[n5]) {
                ++n;
            }
            n3 = n4;
            n4 = n5;
        }
        return n;
    }

    private int count1(int[] nArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, boolean[] blArray4, boolean[] blArray5) {
        int n = 0;
        int n2 = nArray.length;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int n6 : nArray) {
            if (blArray5 != null && !blArray5[n6]) continue;
            if (n3 != -1 && n4 != -1 && n5 != -1 && blArray[n3] && blArray2[n4] && blArray3[n5] && blArray4[n6]) {
                ++n;
            }
            n3 = n4;
            n4 = n5;
            n5 = n6;
        }
        return n;
    }

    public int count1Default(int[] nArray, int[][] nArray2, boolean[] blArray) {
        System.out.println("Error: Corpus.count1Default() not implemented");
        System.exit(1);
        return -1;
    }

    public int count1Default(int[] nArray, boolean[][] blArray, boolean[] blArray2) {
        System.out.println("Error: Corpus.count1Default() not implemented");
        System.exit(1);
        return -1;
    }

    public void print() {
        if (this.storeData) {
            for (int[] nArray : this.data.keySet()) {
                System.out.print(Arrays.toString(nArray) + " (" + this.data.get(nArray) + ") ");
            }
            System.out.println();
        }
    }

    public static void test() {
        int n = 50;
        int n2 = 10;
        int n3 = 50000;
        MersenneTwister mersenneTwister = new MersenneTwister(new Date());
        Poisson poisson = new Poisson((double)n2, (RandomEngine)mersenneTwister);
        DiscreteDistribution discreteDistribution = new DiscreteDistribution(mersenneTwister);
        double[] dArray = new double[n];
        Arrays.fill(dArray, Math.pow(n, -1.0));
        Corpus corpus = new Corpus(n, true);
        for (int i = 0; i < 2; ++i) {
            int n4 = 0;
            int[] nArray = null;
            int n5 = 0;
            while (n5 < n3) {
                n4 = poisson.nextInt();
                if (n4 == 0) continue;
                nArray = new int[n4 + 2];
                nArray[0] = 0;
                for (int j = 1; j <= n4; ++j) {
                    nArray[j] = discreteDistribution.nextIntNormalized(dArray);
                }
                nArray[n4 + 1] = 0;
                corpus.updateCounts(nArray, 0, n4 + 2);
                if (++n5 % 1000 != 0) continue;
                System.out.print(". ");
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[1];
        Alphabet alphabet = FeatureMatrixReader.apply(string, false);
        Corpus corpus = CorpusReader.apply(string2, alphabet, 0, true);
        corpus.print();
    }
}

