/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.ContendersSemiringWeight;
import edu.ucla.fsm.LexicographicSemiring;
import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.Weight;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class ContendersSemiring
extends Semiring {
    static int MAX_VALUE = Integer.MAX_VALUE;
    static int MIN_VALUE = Integer.MIN_VALUE;
    LexicographicSemiring SR = null;
    int M = 0;

    public ContendersSemiring(int n) {
        this.M = n;
        this.SR = new LexicographicSemiring(this.M);
    }

    public ContendersSemiring(LexicographicSemiring lexicographicSemiring) {
        this.M = lexicographicSemiring.N;
        this.SR = lexicographicSemiring;
    }

    @Override
    public Weight otimes(Weight weight, Weight weight2) {
        ContendersSemiringWeight contendersSemiringWeight = new ContendersSemiringWeight();
        LexicographicWeight lexicographicWeight = (LexicographicWeight)weight2;
        if (weight == null) {
            contendersSemiringWeight.add(lexicographicWeight);
        } else {
            ContendersSemiringWeight contendersSemiringWeight2 = (ContendersSemiringWeight)weight;
            Iterator<LexicographicWeight> iterator = contendersSemiringWeight2.iterator();
            while (iterator.hasNext()) {
                contendersSemiringWeight.add(this.SR.otimes(lexicographicWeight, iterator.next()));
            }
        }
        return contendersSemiringWeight;
    }

    @Override
    public Weight oplus(Weight weight, Weight weight2) {
        ContendersSemiringWeight contendersSemiringWeight = new ContendersSemiringWeight();
        if (weight != null) {
            contendersSemiringWeight.addAll((ContendersSemiringWeight)weight);
        }
        if (weight2 != null) {
            contendersSemiringWeight.addAll((ContendersSemiringWeight)weight2);
        }
        int n = contendersSemiringWeight.size();
        LinkedList<LexicographicWeight> linkedList = contendersSemiringWeight.toList();
        int[][] nArray = new int[n][this.M];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int[])linkedList.get(i).value();
        }
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, true);
        boolean[] blArray2 = new boolean[this.M];
        Arrays.fill(blArray2, true);
        boolean[] blArray3 = new boolean[n];
        this.contenders(nArray, blArray, blArray2, blArray3, n, this.M);
        ContendersSemiringWeight contendersSemiringWeight2 = new ContendersSemiringWeight();
        for (int i = n - 1; i >= 0; --i) {
            if (!blArray3[i]) continue;
            contendersSemiringWeight2.add(linkedList.get(i));
        }
        return contendersSemiringWeight2;
    }

    public void contenders(int[][] nArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, int n, int n2) {
        if (this.cardinality(blArray) == 1) {
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                blArray3[i] = true;
            }
        } else {
            int n3;
            boolean[] blArray4 = new boolean[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                if (!blArray2[n3] || !this.distinguishes(nArray, blArray, n3)) continue;
                blArray4[n3] = true;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!blArray4[n3]) continue;
                this.contenders(nArray, this.hmax(nArray, blArray, n3), blArray2, blArray3, n, n2);
            }
        }
    }

    private boolean distinguishes(int[][] nArray, boolean[] blArray, int n) {
        int n2 = blArray.length;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            if (bl && n3 != nArray[i][n]) {
                return true;
            }
            n3 = nArray[i][n];
            bl = true;
        }
        return false;
    }

    private boolean[] hmax(int[][] nArray, boolean[] blArray, int n) {
        int n2 = blArray.length;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i] || nArray[i][n] <= n3) continue;
            n3 = nArray[i][n];
        }
        boolean[] blArray2 = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i] || nArray[i][n] != n3) continue;
            blArray2[i] = true;
        }
        return blArray2;
    }

    private int cardinality(boolean[] blArray) {
        int n = 0;
        for (int i = blArray.length - 1; i >= 0; --i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int cmp(Weight weight, Weight weight2) {
        boolean bl;
        boolean bl2 = weight == null;
        boolean bl3 = bl = weight2 == null;
        if (bl2) {
            if (bl) {
                return 0;
            }
            return -1;
        }
        if (bl) {
            return -1;
        }
        ContendersSemiringWeight contendersSemiringWeight = (ContendersSemiringWeight)weight;
        ContendersSemiringWeight contendersSemiringWeight2 = (ContendersSemiringWeight)weight2;
        if (contendersSemiringWeight.equals(contendersSemiringWeight2)) {
            return 0;
        }
        return -1;
    }

    @Override
    public double delta(Weight weight, Weight weight2) {
        System.out.println("ContendersSemiring.delta() not implemented");
        System.exit(1);
        return 0.0;
    }

    @Override
    public Weight getOne() {
        ContendersSemiringWeight contendersSemiringWeight = new ContendersSemiringWeight();
        contendersSemiringWeight.add(this.SR.getOne());
        return contendersSemiringWeight;
    }

    @Override
    public Weight getZero() {
        return null;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public static void main(String[] stringArray) throws Exception {
        ContendersSemiring contendersSemiring = new ContendersSemiring(14);
        ContendersSemiringWeight contendersSemiringWeight = new ContendersSemiringWeight();
        contendersSemiringWeight.add(new LexicographicWeight(new int[]{0, 0, 0, 0, 0, 0, -1, -2, -2, -1, -4, -1, -2, 0}));
        contendersSemiringWeight.add(new LexicographicWeight(new int[]{0, 0, 0, 0, 0, 0, -1, -4, -4, 0, -2, -3, -1, 0}));
        contendersSemiringWeight.add(new LexicographicWeight(new int[]{0, 0, 0, 0, 0, 0, -1, -3, -3, -1, -3, -3, -2, 0}));
        System.out.println(contendersSemiring.oplus(contendersSemiringWeight, new ContendersSemiringWeight()));
    }
}

