/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.BrzozowskiMinimization;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.HopcroftUllmanConstruction;
import edu.ucla.fsm.IntegerWeight;
import edu.ucla.fsm.Intersect;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.SubsetDeterminization;
import edu.ucla.fsm.SymbolTable;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionFactory;
import edu.ucla.fsm.TransitionIterator;
import java.util.ArrayList;

public class ConstraintCompiler {
    static StateIterator stateiter = new StateIterator();
    static TransitionIterator transiter = new TransitionIterator();
    static IntegerWeight star = new IntegerWeight(1);
    static IntegerWeight zero = new IntegerWeight(0);
    static int verbosity = 0;

    public static FSM markednessSoft(String string, SymbolTable symbolTable) {
        if (verbosity > 5) {
            System.out.println(string);
        }
        FSM fSM = HopcroftUllmanConstruction.apply(string);
        if (verbosity > 5) {
            System.out.println("alpha_1:\n" + fSM);
        }
        fSM = BrzozowskiMinimization.apply(fSM);
        fSM.renameStates();
        if (verbosity > 5) {
            System.out.println("alpha_2:\n" + fSM);
        }
        FSM fSM2 = HopcroftUllmanConstruction.buildDot(FSM.sigmaStarAcceptor(symbolTable), fSM);
        if (verbosity > 5) {
            System.out.println("M_1\n" + fSM2);
        }
        fSM2 = SubsetDeterminization.apply(fSM2);
        fSM2.renameStates();
        if (verbosity > 5) {
            System.out.println("M_2a\n" + fSM2);
        }
        stateiter.init(fSM2.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM2.transitions, stateiter.next());
            while (transiter.hasNext()) {
                Transition transition = transiter.next();
                transition.weight = fSM2.finals.contains(transition.dest) ? star : zero;
            }
        }
        if (verbosity > 5) {
            System.out.println("M_2b\n" + fSM2);
        }
        stateiter.init(fSM2.transitions);
        while (stateiter.hasNext()) {
            int n = stateiter.next();
            fSM2.addFinalState(n);
            transiter.init(fSM2.transitions, n);
            while (transiter.hasNext()) {
                int n2 = ConstraintCompiler.transiter.next().dest;
                fSM2.addFinalState(n2);
            }
        }
        if (verbosity > 5) {
            System.out.println("M_2d\n" + fSM2);
        }
        fSM2 = BrzozowskiMinimization.apply(fSM2);
        if (verbosity > 5) {
            System.out.println("M_4\n" + fSM2);
        }
        return fSM2;
    }

    public static FSM markednessHard(String string, SymbolTable symbolTable) {
        FSM fSM = ConstraintCompiler.markednessSoft(string, symbolTable);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stateiter.init(fSM.transitions);
        while (stateiter.hasNext()) {
            transiter.init(fSM.transitions, stateiter.next());
            while (transiter.hasNext()) {
                Transition transition = transiter.next();
                if (!transition.weight.equals(star)) continue;
                arrayList.add(transition);
            }
        }
        for (Transition transition : arrayList) {
            fSM.removeTransition(transition);
        }
        return fSM;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "(1|2)(3|4)";
        SymbolTable symbolTable = new SymbolTable();
        symbolTable.addEntry(0, "#");
        symbolTable.addEntry(1, "1");
        symbolTable.addEntry(2, "2");
        symbolTable.addEntry(3, "3");
        symbolTable.addEntry(4, "4");
        FSM fSM = ConstraintCompiler.markednessSoft(string, symbolTable);
        System.out.println(fSM);
        FSM fSM2 = FSM.boundedSigmaStarAcceptor(symbolTable);
        System.out.println(fSM2);
        TransitionFactory transitionFactory = new TransitionFactory();
        transitionFactory.match(1).inputFrom(2).weightFrom(2);
        FSM fSM3 = Intersect.apply(fSM2, fSM, transitionFactory);
        System.out.println(fSM3);
        fSM3 = BrzozowskiMinimization.apply(fSM3);
        System.out.println(fSM3);
    }
}

