/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.EnumerateNaturalClasses3;
import edu.ucla.fsm.FeatureConverter;
import edu.ucla.fsm.FeatureMatrixReader;
import edu.ucla.fsm.NaturalClass;
import edu.ucla.fsm.SymbolTable;
import edu.ucla.util.SimpleFileReader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.TreeSet;

public class Alphabet {
    public LinkedList<String> feature_names = null;
    public LinkedList<String> segment_names = null;
    public SymbolTable symbolTable = null;
    public int[][] feature_matrix = null;
    public int number_of_features = 0;
    public int number_of_segments = 0;
    public String[] naturalClassNames = null;
    public int[][] naturalClassFeatures = null;
    public int[][] naturalClassSegments = null;
    public boolean[][] naturalClassDenotations = null;
    public BitSet[] naturalClassSets = null;
    public int[] naturalClassDenotationSizes = null;
    public int number_of_core_classes = 0;
    public int number_of_natural_classes = 0;
    public int[][] moreGeneralThan = null;
    public int[][] moreGeneralThanIntrans = null;
    public boolean[][] moreGeneralThanBool = null;
    public boolean[] complementStatus = null;
    public double[] naturalClassProbs = null;
    public int[] naturalClassFeatureSizes = null;
    public double[] naturalClassComplexity = null;
    public int verbosity = 0;

    public Alphabet(LinkedList<String> linkedList, LinkedList<String> linkedList2, int[][] nArray, BitSet bitSet, boolean bl, int n) {
        this.feature_names = linkedList;
        this.segment_names = linkedList2;
        this.feature_matrix = nArray;
        this.symbolTable = new SymbolTable();
        int n2 = 0;
        for (String string : linkedList2) {
            this.symbolTable.addEntry(n2, string, n2 == 0);
            ++n2;
        }
        this.number_of_features = linkedList.size();
        this.number_of_segments = linkedList2.size();
        this.makeNaturalClasses(bitSet, bl, n);
    }

    public void makeNaturalClasses(BitSet bitSet, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        EnumerateNaturalClasses3.apply(this.feature_names, this.feature_matrix, bitSet, bl, n);
        LinkedList<NaturalClass> linkedList = EnumerateNaturalClasses3.naturalClasses;
        this.number_of_core_classes = EnumerateNaturalClasses3.number_of_core_classes;
        this.number_of_natural_classes = EnumerateNaturalClasses3.number_of_natural_classes;
        if (this.verbosity > 9) {
            for (NaturalClass naturalClass : linkedList) {
                System.out.print(naturalClass.name);
                System.out.print("\t");
                for (n4 = 0; n4 < naturalClass.denotation.length; ++n4) {
                    if (!naturalClass.denotation[n4]) continue;
                    System.out.print(this.segment_names.get(n4) + " ");
                }
                System.out.print("\t");
                System.out.print("size=" + naturalClass.size);
                System.out.print("\t");
                System.out.print(Arrays.toString(naturalClass.features));
                System.out.println();
            }
        }
        this.naturalClassNames = new String[this.number_of_natural_classes];
        this.naturalClassFeatures = new int[this.number_of_natural_classes][this.number_of_features];
        this.naturalClassSegments = new int[this.number_of_natural_classes][];
        this.naturalClassDenotations = new boolean[this.number_of_natural_classes][];
        this.naturalClassSets = new BitSet[this.number_of_natural_classes];
        this.naturalClassDenotationSizes = new int[this.number_of_natural_classes];
        this.moreGeneralThan = new int[this.number_of_natural_classes][];
        this.moreGeneralThanBool = new boolean[this.number_of_natural_classes][];
        this.naturalClassFeatureSizes = new int[this.number_of_natural_classes];
        Object object = null;
        for (int i = 0; i < this.number_of_natural_classes; ++i) {
            object = linkedList.get(i);
            this.naturalClassNames[i] = ((NaturalClass)object).name;
            this.naturalClassFeatures[i] = ((NaturalClass)object).features;
            this.naturalClassSegments[i] = FeatureConverter.toSegments(((NaturalClass)object).denotation);
            this.naturalClassDenotations[i] = ((NaturalClass)object).denotation;
            this.naturalClassSets[i] = new BitSet(this.number_of_segments);
            for (n4 = this.number_of_segments - 1; n4 >= 0; --n4) {
                if (!this.naturalClassDenotations[i][n4]) continue;
                this.naturalClassSets[i].set(n4);
            }
            this.naturalClassDenotationSizes[i] = Alphabet.size(((NaturalClass)object).denotation);
            this.naturalClassFeatureSizes[i] = Alphabet.size(((NaturalClass)object).name);
        }
        double[] dArray = new double[this.number_of_natural_classes];
        double d = 0.0;
        for (n3 = 0; n3 < this.number_of_natural_classes; ++n3) {
            d += (double)this.naturalClassDenotationSizes[n3];
        }
        for (n3 = 0; n3 < this.number_of_natural_classes; ++n3) {
            dArray[n3] = (double)this.naturalClassDenotationSizes[n3] / d;
        }
        this.complementStatus = new boolean[this.number_of_natural_classes];
        for (n3 = 0; n3 < this.number_of_natural_classes; ++n3) {
            if (!this.naturalClassNames[n3].substring(1, 2).equals("^")) continue;
            this.complementStatus[n3] = true;
        }
        int[] nArray = new int[this.number_of_natural_classes];
        int n5 = 0;
        for (int i = 0; i < this.number_of_natural_classes; ++i) {
            n5 = 0;
            for (int j = 0; j < this.number_of_natural_classes; ++j) {
                if (!this.moreGeneralThan(this.naturalClassDenotations[i], this.naturalClassDenotations[j]) || this.complementStatus[i] && !this.complementStatus[j]) continue;
                nArray[n5++] = j;
            }
            this.moreGeneralThan[i] = new int[n5];
            System.arraycopy(nArray, 0, this.moreGeneralThan[i], 0, n5);
            if (this.verbosity > 9) {
                System.out.println("mgt[" + i + "]=" + Arrays.toString(this.moreGeneralThan[i]));
            }
            this.moreGeneralThanBool[i] = new boolean[this.number_of_natural_classes];
            for (int n6 : this.moreGeneralThan[i]) {
                this.moreGeneralThanBool[i][n6] = true;
            }
            if (this.verbosity <= 9) continue;
            System.out.println("mgt[" + i + "]=" + Arrays.toString(this.moreGeneralThanBool[i]));
        }
        this.moreGeneralThanIntrans = new int[this.number_of_natural_classes][];
        boolean[][] blArray = new boolean[this.number_of_natural_classes][this.number_of_natural_classes];
        for (n2 = 0; n2 < this.number_of_natural_classes; ++n2) {
            blArray[n2] = Arrays.copyOf(this.moreGeneralThanBool[n2], this.number_of_natural_classes);
            for (int n7 : this.moreGeneralThan[n2]) {
                if (n7 == n2) continue;
                for (int n8 : this.moreGeneralThan[n7]) {
                    if (n8 == n7) continue;
                    blArray[n2][n8] = false;
                }
            }
            n5 = 0;
            this.moreGeneralThanIntrans[n2] = new int[this.moreGeneralThan[n2].length];
            for (int n7 : this.moreGeneralThan[n2]) {
                if (!blArray[n2][n7]) continue;
                this.moreGeneralThanIntrans[n2][n5] = n7;
                ++n5;
            }
            this.moreGeneralThanIntrans[n2] = Arrays.copyOf(this.moreGeneralThanIntrans[n2], n5);
        }
        System.out.println("number of segments: " + this.number_of_segments);
        System.out.println("number of natural classes: " + this.number_of_natural_classes);
        System.out.println("number of core classes: " + this.number_of_core_classes);
        for (n2 = 0; n2 < this.number_of_natural_classes; ++n2) {
            System.out.print(this.naturalClassNames[n2] + " (" + this.naturalClassDenotationSizes[n2] + ")  ");
        }
        System.out.println();
    }

    public boolean moreGeneralThan(boolean[] blArray, boolean[] blArray2) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray2[i] || blArray[i]) continue;
            return false;
        }
        return true;
    }

    public static int size(boolean[] blArray) {
        int n = 0;
        for (int i = blArray.length - 1; i >= 0; --i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public static int size(String string) {
        return string.split(",").length;
    }

    public int toSingletonClass(String string) {
        int n = this.segment_names.indexOf(string);
        int n2 = -1;
        for (int i = 0; i < this.number_of_natural_classes; ++i) {
            if (!this.naturalClassDenotations[i][n] || i != 0 && this.naturalClassDenotationSizes[i] != 1) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            System.out.println("Error: could not find a natural class equal to {" + string + "}");
            System.exit(1);
        }
        return n2;
    }

    public String toSingletonConstraint(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.toSingletonClass(stringArray[i]);
        }
        return FeatureConverter.toFeatureConstraint(nArray, this.naturalClassNames);
    }

    public String toSingletonConstraint(String string) {
        return this.toSingletonConstraint(string.split(" "));
    }

    public int[] encodeString(String string) {
        return this.encodeString(string, " ");
    }

    public int[] encodeString(String string, String string2) {
        String[] stringArray = string.split(string2);
        int[] nArray = new int[stringArray.length + 2];
        int n = 0;
        nArray[n++] = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[n++] = this.segment_names.indexOf(stringArray[i]);
        }
        nArray[n] = 0;
        return nArray;
    }

    public String decodeString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray.length < 3) {
            return stringBuffer.toString();
        }
        for (int i = 1; i < nArray.length - 1; ++i) {
            stringBuffer.append(this.segment_names.get(nArray[i]));
            if (i >= nArray.length - 2) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Alphabet alphabet = FeatureMatrixReader.apply(stringArray[0], 0);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < alphabet.number_of_natural_classes; ++i) {
            treeSet.clear();
            for (n = 0; n < alphabet.number_of_segments; ++n) {
                if (!alphabet.naturalClassDenotations[i][n]) continue;
                treeSet.add(alphabet.segment_names.get(n));
            }
            System.out.print("\t" + treeSet);
            System.out.println();
        }
        if (stringArray.length > 1) {
            String[] stringArray2 = SimpleFileReader.apply((String)stringArray[1]);
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.println(alphabet.toSingletonConstraint(stringArray2[n]));
            }
        }
    }
}

