/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.util;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import edu.ucla.util.DiscreteObjective;
import edu.ucla.util.DiscretePoint;
import edu.ucla.util.DiscreteProposal;
import java.util.Date;

public class SimulatedAnnealing {
    public static MersenneTwister mt = null;
    public static Uniform uniform = null;
    public static double TOL = 1.0E-12;
    DiscreteObjective f = null;
    DiscreteProposal q = null;
    int N = 0;
    int M = 0;
    double T0 = 1.0;
    double mu = 0.01;
    double min = 1.0E-6;
    DiscretePoint x_old = null;
    DiscretePoint x_new = null;
    double E_old = 0.0;
    double E_new = 0.0;
    double T = 1.0;
    int n = 0;
    int m = 0;
    private int verbosity = 0;

    public SimulatedAnnealing(DiscreteObjective discreteObjective, DiscreteProposal discreteProposal, int n, int n2, double d, double d2, double d3) {
        if (n <= 0) {
            System.out.println("SimulatedAnnealing: number of iterations must be > 0");
            System.exit(1);
        }
        if (n2 <= 0) {
            System.out.println("SimulatedAnnealing: number of iterations at temperature must be > 0");
            System.exit(1);
        }
        if (d <= 0.0) {
            System.out.println("SimulatedAnnealing: initial temperature must be > 0.0");
            System.exit(1);
        }
        if (d2 < 1.0) {
            System.out.println("SimulatedAnnealing: temperature change (mu) must be >= 1.0");
            System.exit(1);
        }
        if (d3 > d) {
            System.out.println("SimulatedAnnealing: minimum temperature must be <= initial temperature");
            System.exit(1);
        }
        this.f = discreteObjective;
        this.q = discreteProposal;
        this.N = n;
        this.M = n2;
        this.T0 = d;
        this.mu = d2;
        this.min = d3;
        mt = new MersenneTwister(new Date());
        uniform = new Uniform((RandomEngine)mt);
    }

    public void init(DiscretePoint discretePoint) {
        this.T = this.T0;
        this.n = 0;
        this.m = 0;
        this.x_old = discretePoint;
        this.E_old = this.f.apply(this.x_old);
        System.out.println("initial state: " + this.x_old + ", at E=" + this.E_old);
    }

    public DiscretePoint run() {
        while (this.n < this.N) {
            this.run1();
            if (!(Math.abs(this.E_old) < TOL)) continue;
            break;
        }
        return this.x_old;
    }

    public DiscretePoint run1() {
        this.x_new = this.q.apply(this.x_old, this.x_new);
        this.E_new = this.f.apply(this.x_new);
        if (this.verbosity > 0) {
            System.out.println("x_old = " + this.x_old + "; E_old = " + this.E_old);
        }
        if (this.verbosity > 0) {
            System.out.println("x_new = " + this.x_new + "; E_new = " + this.E_new);
        }
        if (this.verbosity > 0) {
            System.out.println("delta E = " + (this.E_old - this.E_new));
        }
        if (this.accept(this.E_old, this.E_new, this.T)) {
            this.x_new.copyInto(this.x_old);
            this.E_old = this.E_new;
            if (this.verbosity > 0) {
                System.out.println(this.x_old);
            }
        }
        ++this.n;
        ++this.m;
        if (this.m >= this.M) {
            this.T /= this.mu;
            if (this.T < this.min) {
                this.T = this.min;
            }
            this.m = 0;
        }
        return this.x_old;
    }

    public boolean accept(double d, double d2, double d3) {
        boolean bl = false;
        double d4 = d2 - d;
        if (d4 <= 0.0) {
            if (this.verbosity > 9) {
                System.out.println("equal or lower energy -> accepted");
            }
            bl = true;
        } else {
            double d5 = Math.exp(-(d2 - d) / d3);
            if (this.verbosity > 9) {
                System.out.println("higher energy: acceptance probability at T=" + d3 + " is " + d5);
            }
            if (d5 > 0.0 && uniform.nextDoubleFromTo(0.0, 1.0) <= d5) {
                bl = true;
                if (this.verbosity > 9) {
                    System.out.println("accepted");
                }
            } else if (this.verbosity > 9) {
                System.out.println("rejected");
            }
        }
        return bl;
    }
}

