/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.util;

import edu.ucla.util.Node;
import edu.ucla.util.Scanner;
import java.util.LinkedList;

public class RegexpParser {
    Scanner scanner = null;
    static String DOT = ".";
    static String PIPE = "|";
    static String STAR = "*";
    static String OPEN_PAREN = "(";
    static String CLOSE_PAREN = ")";
    static LinkedList<Node> stack = new LinkedList();

    public RegexpParser() {
    }

    public RegexpParser(Scanner scanner) {
        this.scanner = scanner;
    }

    public Node parse() {
        this.scanner.init();
        stack.clear();
        this.process();
        return stack.poll();
    }

    public void process() {
        String string = this.scanner.peek();
        if (string == null) {
            return;
        }
        if (string.equals(CLOSE_PAREN)) {
            return;
        }
        String string2 = this.scanner.pop();
        if (string2.equals(STAR)) {
            Node node = stack.poll();
            if (node == null) {
                System.out.println("Error: attempt to add Kleene star to null expression");
                System.exit(1);
            }
            stack.offer(new Node(Node.Type.STAR, null, node, null));
        } else if (string2.equals(DOT)) {
            Node node = stack.poll();
            this.process();
            Node node2 = stack.poll();
            if (node == null || node2 == null) {
                System.out.println("Error: null argument to regexp concatenation");
                System.exit(1);
            }
            stack.offer(new Node(Node.Type.DOT, null, node, node2));
        } else if (string2.equals(PIPE)) {
            Node node = stack.poll();
            this.process();
            Node node3 = stack.poll();
            if (node == null || node3 == null) {
                System.out.println("Error: null argument to regexp disjunction");
                System.exit(1);
            }
            stack.offer(new Node(Node.Type.PIPE, null, node, node3));
        } else if (string2.equals(OPEN_PAREN)) {
            this.process();
            string2 = this.scanner.pop();
            if (!string2.equals(CLOSE_PAREN)) {
                System.out.println("Error: Unbalanced parenthesis in regexp");
                System.exit(1);
            }
            Node node = stack.poll();
            stack.offer(new Node(Node.Type.GROUP, null, node, null));
        } else {
            stack.offer(new Node(Node.Type.SEGMENT, string2, null, null));
        }
        this.process();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.exit(0);
        }
        String string = stringArray[0];
        Scanner scanner = new Scanner(string);
        RegexpParser regexpParser = new RegexpParser(scanner);
        Node node = regexpParser.parse();
        node.print();
    }
}

