/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.util;

import java.util.Arrays;

public class LevenshteinDistance {
    private static double INS = 1.0;
    private static double[][] D = null;
    private static int verbosity = 0;

    private static double minimum(double d, double d2, double d3) {
        return Math.min(Math.min(d, d2), d3);
    }

    public static void setVerbosity(int n) {
        verbosity = n;
    }

    public static void setINS(double d) {
        INS = d;
    }

    public static void setDistanceMatrix(double[][] dArray) {
        D = dArray;
    }

    public static double computeLevenshteinDistance(int[] nArray, int[] nArray2) {
        int n;
        double[][] dArray = new double[nArray.length + 1][nArray2.length + 1];
        for (n = 0; n <= nArray.length; ++n) {
            dArray[n][0] = (double)n * INS;
        }
        for (n = 0; n <= nArray2.length; ++n) {
            dArray[0][n] = (double)n * INS;
        }
        for (n = 1; n <= nArray.length; ++n) {
            for (int i = 1; i <= nArray2.length; ++i) {
                dArray[n][i] = LevenshteinDistance.minimum(dArray[n - 1][i] + INS, dArray[n][i - 1] + INS, dArray[n - 1][i - 1] + (nArray[n - 1] == nArray2[i - 1] ? 0.0 : D[nArray[n - 1]][nArray2[i - 1]]));
            }
        }
        if (verbosity > 0) {
            for (n = 0; n < dArray.length; ++n) {
                System.out.println(Arrays.toString(dArray[n]));
            }
        }
        return dArray[nArray.length][nArray2.length];
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{0, 1, 2, 1, 0};
        int[] nArray2 = new int[]{0, 2, 1, 1, 0};
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {0.0, 0.0, 1.0}};
        LevenshteinDistance.setVerbosity(10);
        LevenshteinDistance.setDistanceMatrix(dArrayArray);
        LevenshteinDistance.setINS(0.25);
        System.out.println(LevenshteinDistance.computeLevenshteinDistance(nArray, nArray2));
    }
}

