/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.util;

import cern.jet.random.engine.MersenneTwister;
import java.util.Arrays;
import java.util.Date;

public class DiscreteDistribution {
    MersenneTwister mt = null;

    public DiscreteDistribution(MersenneTwister mersenneTwister) {
        this.mt = mersenneTwister;
    }

    public int nextInt(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        double d2 = this.mt.nextDouble();
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!((d3 += dArray[i] / d) > d2)) continue;
            return i;
        }
        return n - 1;
    }

    public int nextIntNormalized(double[] dArray) {
        int n = dArray.length;
        double d = this.mt.nextDouble();
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!((d2 += dArray[i]) > d)) continue;
            return i;
        }
        return n - 1;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        MersenneTwister mersenneTwister = new MersenneTwister(new Date());
        int n3 = 100;
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = mersenneTwister.nextDouble();
        }
        double[] dArray2 = new double[n3];
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d += dArray[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = dArray[n2] / d;
        }
        DiscreteDistribution discreteDistribution = new DiscreteDistribution(mersenneTwister);
        double[] dArray3 = new double[n3];
        int n4 = 1000000;
        for (n = 0; n < n4; ++n) {
            int n5 = discreteDistribution.nextIntNormalized(dArray2);
            dArray3[n5] = dArray3[n5] + 1.0;
        }
        System.out.println(Arrays.toString(dArray2));
        n = 0;
        while (n < n3) {
            int n6 = n++;
            dArray3[n6] = dArray3[n6] / (double)n4;
        }
        System.out.println(Arrays.toString(dArray3));
    }
}

