/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.util;

import java.util.Arrays;

public class CartesianProductIterator {
    private int[][] sets = null;
    private int[] set_size = null;
    private int[] set_position = null;
    private int n = 0;
    private int index = 0;
    private int[] x = null;
    private boolean firstElement = false;

    public void init(int[][] nArray) {
        int n;
        this.sets = nArray;
        this.n = this.sets.length;
        this.set_size = new int[this.n];
        for (n = 0; n < this.n; ++n) {
            this.set_size[n] = this.sets[n].length;
        }
        this.set_position = new int[this.n];
        this.index = this.n - 1;
        this.x = new int[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = this.sets[n][0];
        }
        this.firstElement = true;
    }

    public int[] next() {
        if (this.firstElement) {
            this.firstElement = false;
            return this.x;
        }
        while (this.index >= 0) {
            if (this.set_position[this.index] < this.set_size[this.index] - 1) {
                int n = this.index;
                this.set_position[n] = this.set_position[n] + 1;
                this.x[this.index] = this.sets[this.index][this.set_position[this.index]];
                this.index = this.n - 1;
                break;
            }
            this.x[this.index] = this.sets[this.index][0];
            this.set_position[this.index] = 0;
            --this.index;
        }
        if (this.index < 0) {
            return null;
        }
        return this.x;
    }

    public static void main(String[] stringArray) throws Exception {
        int[] nArray = new int[]{1, 2, 3};
        int[] nArray2 = new int[]{4, 5, 6};
        int[] nArray3 = new int[]{7, 8, 9};
        int[][] nArrayArray = new int[][]{nArray, nArray2, nArray3};
        CartesianProductIterator cartesianProductIterator = new CartesianProductIterator();
        cartesianProductIterator.init(nArrayArray);
        int[] nArray4 = cartesianProductIterator.next();
        while (nArray4 != null) {
            System.out.println(Arrays.toString(nArray4));
            nArray4 = cartesianProductIterator.next();
        }
        cartesianProductIterator.init(new int[][]{nArray});
        nArray4 = cartesianProductIterator.next();
        while (nArray4 != null) {
            System.out.println(Arrays.toString(nArray4));
            nArray4 = cartesianProductIterator.next();
        }
    }
}

